/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.theoneprobe;

import java.util.function.Function;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.api.misc.IPneumaticCraftProbeable;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.ElementPressure;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.TOPInfoProvider;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;

public class TOPInit
implements Function<ITheOneProbe, Void> {
    static final ResourceLocation ELEMENT_PRESSURE = PneumaticRegistry.RL("pressure");
    private static final ChatFormatting COLOR = ChatFormatting.GRAY;

    @Override
    public Void apply(ITheOneProbe theOneProbe) {
        Log.info("Enabled support for The One Probe", new Object[0]);
        theOneProbe.registerElementFactory((IElementFactory)new ElementPressure.Factory());
        theOneProbe.registerProvider(new IProbeInfoProvider(){

            public ResourceLocation getID() {
                return PneumaticRegistry.RL("default");
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
                if (blockState.getBlock() instanceof IPneumaticCraftProbeable || blockState.is(PneumaticCraftTags.Blocks.PROBE_TARGET)) {
                    TOPInfoProvider.handleBlock(mode, probeInfo, player, world, data);
                }
                SemiblockTracker.getInstance().getAllSemiblocks(world, data.getPos(), data.getSideHit()).filter(sb -> !(sb instanceof IDirectionalSemiblock) || ((IDirectionalSemiblock)((Object)sb)).getSide() == data.getSideHit()).forEach(sb -> TOPInfoProvider.handleSemiblock(player, mode, probeInfo, sb));
            }
        });
        theOneProbe.registerEntityProvider(new IProbeInfoEntityProvider(){

            public String getID() {
                return "pneumaticcraft:entity";
            }

            public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, Entity entity, IProbeHitEntityData data) {
                if (entity instanceof ISemiBlock) {
                    ISemiBlock semiblock = (ISemiBlock)entity;
                    CompoundTag tag = semiblock.serializeNBT(new CompoundTag());
                    semiblock.addTooltip(arg_0 -> ((IProbeInfo)probeInfo).text(arg_0), player, tag, player.isShiftKeyDown());
                    BlockPos pos = semiblock.getBlockPos();
                    BlockState state = world.getBlockState(pos);
                    if (!state.isAir()) {
                        IProbeInfo h2 = probeInfo.horizontal();
                        h2.item(new ItemStack((ItemLike)state.getBlock()));
                        IProbeInfo v = h2.vertical();
                        MutableComponent text = Component.translatable((String)state.getBlock().getDescriptionId());
                        v.text((Component)text.copy().withStyle(ChatFormatting.YELLOW));
                        v.text((Component)Component.literal((String)(ChatFormatting.BLUE.toString() + ChatFormatting.ITALIC + ModNameCache.getModName(state.getBlock()))));
                    }
                }
                IOHelper.getCapV(entity, PNCCapabilities.AIR_HANDLER_ENTITY).ifPresent(h -> {
                    String p = PneumaticCraftUtils.roundNumberTo(h.getPressure(), 1);
                    probeInfo.text((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", p).withStyle(COLOR));
                });
                IOHelper.getCap(entity, Capabilities.FluidHandler.ENTITY).ifPresent(h -> TOPInfoProvider.handleFluidTanks(mode, probeInfo, h));
            }
        });
        return null;
    }
}

