/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.waila;

import java.util.LinkedHashSet;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.entity.IInfoForwarder;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.TemperatureData;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class PneumaticProvider {
    private static final ResourceLocation ID = PneumaticRegistry.RL("pneumatic");

    public static class ComponentProvider
    implements IBlockComponentProvider {
        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            CompoundTag tag = blockAccessor.getServerData();
            BlockEntity te = blockAccessor.getBlockEntity();
            if (te instanceof IInfoForwarder) {
                BlockPos infoPos = new BlockPos(tag.getInt("infoX"), tag.getInt("infoY"), tag.getInt("infoZ"));
                te = blockAccessor.getLevel().getBlockEntity(infoPos);
            }
            if (te != null) {
                ListTag l = tag.getList("pressure", 9);
                for (int i = 0; i < l.size(); ++i) {
                    ListTag l2 = l.getList(i);
                    String pressureStr = PneumaticCraftUtils.roundNumberTo(l2.getFloat(0), 2);
                    String dangerPressureStr = PneumaticCraftUtils.roundNumberTo(l2.getFloat(1), 1);
                    iTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressureMax", pressureStr, dangerPressureStr));
                }
                this.handleHeatData(iTooltip, tag);
                if (blockAccessor.getPlayer().isCrouching()) {
                    this.handleFluidData(iTooltip, tag);
                }
            }
        }

        private void handleFluidData(ITooltip tooltip, CompoundTag tag) {
            ListTag list = tag.getList("tanks", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag subtag = list.getCompound(i);
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)subtag);
                MutableComponent fluidDesc = fluidStack.isEmpty() ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]) : PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.fluidmB", fluidStack.getAmount()).append(" ").append((Component)PneumaticCraftUtils.xlate(fluidStack.getTranslationKey(), new Object[0]));
                tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.tank", i + 1, fluidDesc.copy().withStyle(ChatFormatting.AQUA)));
            }
        }

        private void handleHeatData(ITooltip tooltip, CompoundTag tag) {
            if (tag.contains("heatData")) {
                TemperatureData tempData = TemperatureData.fromNBT(tag.getCompound("heatData"));
                if (tempData.isMultisided()) {
                    for (Direction face : DirectionUtil.VALUES) {
                        if (!tempData.hasData(face)) continue;
                        tooltip.add(HeatUtil.formatHeatString(face, (int)tempData.getTemperature(face)));
                    }
                } else if (tempData.hasData(null)) {
                    tooltip.add(HeatUtil.formatHeatString((int)tempData.getTemperature(null)));
                }
            }
        }

        public ResourceLocation getUid() {
            return ID;
        }
    }

    public static class DataProvider
    implements IServerDataProvider<BlockAccessor> {
        public ResourceLocation getUid() {
            return ID;
        }

        public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
            BlockEntity beInfo;
            Direction[] directionArray = blockAccessor.getBlockEntity();
            if (directionArray instanceof IInfoForwarder) {
                IInfoForwarder forwarder = (IInfoForwarder)directionArray;
                beInfo = forwarder.getInfoBlockEntity();
                if (beInfo != null) {
                    compoundTag.putInt("infoX", beInfo.getBlockPos().getX());
                    compoundTag.putInt("infoY", beInfo.getBlockPos().getY());
                    compoundTag.putInt("infoZ", beInfo.getBlockPos().getZ());
                }
            } else {
                beInfo = blockAccessor.getBlockEntity();
            }
            if (beInfo != null) {
                LinkedHashSet set = new LinkedHashSet();
                IOHelper.getCap(beInfo, PNCCapabilities.AIR_HANDLER_MACHINE, null).ifPresent(set::add);
                for (Direction dir : DirectionUtil.VALUES) {
                    IOHelper.getCap(beInfo, PNCCapabilities.AIR_HANDLER_MACHINE, dir).ifPresent(set::add);
                }
                ListTag l = new ListTag();
                for (IAirHandlerMachine h2 : set) {
                    ListTag l2 = new ListTag();
                    l2.add((Object)FloatTag.valueOf((float)h2.getPressure()));
                    l2.add((Object)FloatTag.valueOf((float)h2.getDangerPressure()));
                    l.add((Object)l2);
                }
                compoundTag.put("pressure", (Tag)l);
                if (IOHelper.getCap(beInfo, PNCCapabilities.HEAT_EXCHANGER_BLOCK, null).isPresent()) {
                    compoundTag.put("heatData", (Tag)new TemperatureData(beInfo).toNBT());
                }
                IOHelper.getCap(beInfo, Capabilities.FluidHandler.BLOCK, null).ifPresent(h -> {
                    ListTag list = new ListTag();
                    for (int i = 0; i < h.getTanks(); ++i) {
                        list.add((Object)h.getFluidInTank(i).writeToNBT(new CompoundTag()));
                    }
                    compoundTag.put("tanks", (Tag)list);
                });
            }
        }
    }
}

