/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.common.block.entity.RangeManager;
import me.desht.pneumaticcraft.common.block.entity.heat.HeatSinkBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractSemiblockEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureBlock;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class AirGrateModule
extends AbstractTubeModule {
    private int grateRange;
    private boolean vacuum;
    private final Set<HeatSinkBlockEntity> heatSinks = new HashSet<HeatSinkBlockEntity>();
    private boolean showRange;
    @Nonnull
    private EntityFilter entityFilter = EntityFilter.allow();
    private final Map<BlockPos, Boolean> traceabilityCache = new HashMap<BlockPos, Boolean>();
    private BlockCapabilityCache<IItemHandler, Direction> itemInsertionCache;
    private BlockCapabilityCache<IFluidHandler, Direction> fluidInsertionCache;

    public AirGrateModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
    }

    @Override
    public double getWidth() {
        return 16.0;
    }

    @Override
    public Item getItem() {
        return (Item)ModItems.AIR_GRATE_MODULE.get();
    }

    @Override
    public void tickCommon() {
        Level world = this.pressureTube.nonNullLevel();
        BlockPos pos = this.pressureTube.getBlockPos();
        if ((world.getGameTime() & 0x1FL) == 0L) {
            this.traceabilityCache.clear();
        }
        int oldGrateRange = this.grateRange;
        this.grateRange = this.calculateRange();
        if (oldGrateRange != this.grateRange) {
            this.onGrateRangeChanged();
        }
        Vec3 tileVec = Vec3.atCenterOf((Vec3i)pos).add((double)this.getDirection().getStepX() * 0.49, (double)this.getDirection().getStepY() * 0.49, (double)this.getDirection().getStepZ() * 0.49);
        this.pushEntities(world, pos, tileVec);
    }

    private void onGrateRangeChanged() {
        if (!this.pressureTube.nonNullLevel().isClientSide) {
            PNCCapabilities.getAirHandler(this.getTube()).ifPresent(h -> NetworkHandler.sendToAllTracking((CustomPacketPayload)new PacketUpdatePressureBlock(this.getTube().getBlockPos(), null, h.getSideLeaking(), h.getAir()), this.getTube()));
        } else if (this.showRange) {
            AreaRenderManager.getInstance().showArea(RangeManager.getFrame(this.getAffectedBoundingBox()), 1627373664, this.pressureTube, false);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.coolHeatSinks();
    }

    private BoundingBox getAffectedBoundingBox() {
        BlockPos pos = this.pressureTube.getBlockPos().relative(this.getDirection(), this.grateRange + 1);
        return new BoundingBox(pos).inflatedBy(this.grateRange);
    }

    private int calculateRange() {
        float range = this.pressureTube.getPressure() * 4.0f;
        boolean bl = this.vacuum = range < 0.0f;
        if (this.vacuum) {
            range *= -4.0f;
        }
        return (int)range;
    }

    private void pushEntities(Level world, BlockPos pos, Vec3 traceVec) {
        if (this.entityFilter.isNone()) {
            return;
        }
        List entities = world.getEntitiesOfClass(Entity.class, AABB.of((BoundingBox)this.getAffectedBoundingBox()), (Predicate)this.entityFilter);
        double d0 = this.grateRange * 3;
        int entitiesMoved = 0;
        for (Entity entity : entities) {
            double z;
            double d4;
            double d5;
            if (this.ignoreEntity(entity) || !entity.isAlive() || !this.rayTraceOK(entity, traceVec)) continue;
            if (!entity.level().isClientSide) {
                this.tryInsertion(traceVec, entity);
            }
            double x = (entity.getX() - (double)pos.getX() - 0.5) / d0;
            double y = (entity.getY() + (double)entity.getEyeHeight() - (double)pos.getY() - 0.5) / d0;
            BlockPos entityPos = entity.blockPosition();
            if (!Block.canSupportCenter((LevelReader)world, (BlockPos)entityPos, (Direction)Direction.UP) && !world.isEmptyBlock(entityPos)) {
                y -= 0.15;
            }
            if (!((d5 = 1.0 - (d4 = Math.sqrt(x * x + y * y + (z = (entity.getZ() - (double)pos.getZ() - 0.5) / d0) * z))) > 0.0)) continue;
            d5 *= d5;
            if (this.vacuum) {
                d5 *= -1.0;
            }
            if (entity.onGround() && entity instanceof ItemEntity) {
                entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, 0.25, 0.0));
            }
            entity.move(MoverType.SELF, new Vec3(x * d5, y * d5, z * d5));
            ++entitiesMoved;
            if (!world.isClientSide || !(world.random.nextDouble() < 0.2)) continue;
            if (this.vacuum) {
                world.addParticle((ParticleOptions)AirParticleData.DENSE, entity.getX(), entity.getY(), entity.getZ(), -x, -y, -z);
                continue;
            }
            world.addParticle((ParticleOptions)AirParticleData.DENSE, (double)pos.getX() + 0.5 + (double)this.getDirection().getStepX(), (double)pos.getY() + 0.5 + (double)this.getDirection().getStepY(), (double)pos.getZ() + 0.5 + (double)this.getDirection().getStepZ(), x, y, z);
        }
        if (!world.isClientSide) {
            int usage = this.pressureTube.getPressure() > 0.0f ? -2 : 2;
            this.pressureTube.addAir(entitiesMoved * usage);
        }
    }

    private void tryInsertion(Vec3 traceVec, Entity entity) {
        if (entity instanceof ItemEntity && this.isCloseEnough(entity, traceVec)) {
            this.tryItemInsertion((ItemEntity)entity);
        } else if (entity instanceof ExperienceOrb && this.isCloseEnough(entity, traceVec)) {
            this.tryOrbInsertion((ExperienceOrb)entity);
        }
    }

    private void tryItemInsertion(ItemEntity entity) {
        ItemStack stack = entity.getItem();
        this.getItemInsertionCap().ifPresent(handler -> {
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
            if (excess.isEmpty()) {
                entity.discard();
            } else {
                entity.setItem(excess);
            }
        });
    }

    private void tryOrbInsertion(ExperienceOrb entity) {
        this.getFluidInsertionCap().ifPresent(handler -> {
            if (PneumaticCraftUtils.fillTankWithOrb(handler, entity, IFluidHandler.FluidAction.EXECUTE)) {
                entity.discard();
            }
        });
    }

    private boolean isCloseEnough(Entity entity, Vec3 traceVec) {
        return entity.distanceToSqr(traceVec) < 1.0;
    }

    private boolean ignoreEntity(Entity entity) {
        if (entity instanceof Player) {
            return ((Player)entity).isCreative() || entity.isShiftKeyDown() || entity.isSpectator();
        }
        if (entity instanceof ItemEntity || entity instanceof ExperienceOrb) {
            return false;
        }
        return !entity.isPushable() || entity instanceof AbstractSemiblockEntity;
    }

    private boolean rayTraceOK(Entity entity, Vec3 traceVec) {
        BlockPos pos = BlockPos.containing((Position)entity.getEyePosition(0.0f));
        return this.traceabilityCache.computeIfAbsent(pos, k -> {
            Vec3 entityVec = new Vec3(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ());
            ClipContext ctx = new ClipContext(entityVec, traceVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity);
            BlockHitResult trace = entity.getCommandSenderWorld().clip(ctx);
            return trace.getBlockPos().equals((Object)this.pressureTube.getBlockPos());
        });
    }

    private Optional<IItemHandler> getItemInsertionCap() {
        Direction[] directionArray;
        if (this.itemInsertionCache == null && (directionArray = this.pressureTube.getLevel()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)directionArray;
            for (Direction dir : DirectionUtil.VALUES) {
                BlockPos neighborPos = this.pressureTube.getBlockPos().relative(dir);
                if (level.getCapability(Capabilities.ItemHandler.BLOCK, neighborPos, (Object)dir.getOpposite()) == null) continue;
                this.itemInsertionCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)level, (BlockPos)neighborPos, (Object)dir.getOpposite(), () -> !this.getTube().isRemoved(), () -> {
                    this.itemInsertionCache = null;
                });
            }
        }
        return this.itemInsertionCache == null ? Optional.empty() : Optional.ofNullable((IItemHandler)this.itemInsertionCache.getCapability());
    }

    private Optional<IFluidHandler> getFluidInsertionCap() {
        Direction[] directionArray;
        if (this.fluidInsertionCache == null && (directionArray = this.pressureTube.getLevel()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)directionArray;
            for (Direction dir : DirectionUtil.VALUES) {
                BlockPos neighborPos = this.pressureTube.getBlockPos().relative(dir);
                if (level.getCapability(Capabilities.FluidHandler.BLOCK, neighborPos, (Object)dir.getOpposite()) == null) continue;
                this.fluidInsertionCache = BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)level, (BlockPos)neighborPos, (Object)dir.getOpposite(), () -> !this.getTube().isRemoved(), () -> {
                    this.itemInsertionCache = null;
                });
            }
        }
        return this.fluidInsertionCache == null ? Optional.empty() : Optional.ofNullable((IFluidHandler)this.fluidInsertionCache.getCapability());
    }

    private void coolHeatSinks() {
        if (this.grateRange >= 2) {
            int curTeIndex = (int)(this.pressureTube.nonNullLevel().getGameTime() % 27L);
            BlockPos curPos = this.pressureTube.getBlockPos().relative(this.dir, 2).offset(-1 + curTeIndex % 3, -1 + curTeIndex / 3 % 3, -1 + curTeIndex / 9 % 3);
            BlockEntity te = this.pressureTube.nonNullLevel().getBlockEntity(curPos);
            if (te instanceof HeatSinkBlockEntity) {
                this.heatSinks.add((HeatSinkBlockEntity)te);
            }
            Iterator<HeatSinkBlockEntity> iterator = this.heatSinks.iterator();
            int tubesCooled = 0;
            while (iterator.hasNext()) {
                HeatSinkBlockEntity heatSink = iterator.next();
                if (heatSink.isRemoved()) {
                    iterator.remove();
                    continue;
                }
                for (int i = 0; i < 4; ++i) {
                    heatSink.onFannedByAirGrate();
                }
                ++tubesCooled;
            }
            if (tubesCooled > 0) {
                this.pressureTube.addAir(-(5 + tubesCooled / 3));
            }
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.vacuum = tag.getBoolean("vacuum");
        this.grateRange = tag.getInt("grateRange");
        String f = tag.getString("entityFilter");
        this.entityFilter = f.isEmpty() ? EntityFilter.allow() : EntityFilter.fromString(f, EntityFilter.allow());
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.putBoolean("vacuum", this.vacuum);
        tag.putInt("grateRange", this.grateRange);
        if (this.entityFilter != EntityFilter.allow()) {
            tag.putString("entityFilter", this.entityFilter.toString());
        }
        return tag;
    }

    @Override
    public void addInfo(List<Component> curInfo) {
        super.addInfo(curInfo);
        String k = this.grateRange == 0 ? "idle" : (this.vacuum ? "attracting" : "repelling");
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.airGrateModule." + k, new Object[0]).withStyle(ChatFormatting.WHITE));
        if (this.grateRange != 0) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.range", this.grateRange).withStyle(ChatFormatting.WHITE));
        }
        if (this.entityFilter != EntityFilter.allow()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.entityFilter.show", this.entityFilter.toString()).withStyle(ChatFormatting.WHITE));
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public AABB getRenderBoundingBox() {
        return new AABB(this.pressureTube.getBlockPos().relative(this.getDirection(), this.grateRange + 1)).inflate((double)(this.grateRange * 2));
    }

    @Nonnull
    public EntityFilter getEntityFilter() {
        return this.entityFilter;
    }

    public void setEntityFilter(@Nonnull EntityFilter filter) {
        this.entityFilter = filter;
        this.setChanged();
    }

    public boolean isShowRange() {
        return this.showRange;
    }

    public void setShowRange(boolean showRange) {
        this.showRange = showRange;
        if (showRange) {
            AreaRenderManager.getInstance().showArea(RangeManager.getFrame(this.getAffectedBoundingBox()), 1627373664, this.pressureTube, false);
        } else {
            AreaRenderManager.getInstance().removeHandlers(this.pressureTube);
        }
        this.setChanged();
    }

    @Override
    public void onRemoved() {
        if (this.pressureTube.nonNullLevel().isClientSide) {
            AreaRenderManager.getInstance().removeHandlers(this.pressureTube);
        }
    }
}

