/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.PriorityQueue;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.drone.LogisticsManager;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateLogisticsModule;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.INetworkedModule;
import me.desht.pneumaticcraft.common.tubemodules.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class LogisticsModule
extends AbstractTubeModule
implements INetworkedModule {
    private AbstractLogisticsFrameEntity cachedFrame;
    private int colorChannel;
    private int ticksSinceAction = -1;
    private int ticksSinceNotEnoughAir = -1;
    private int ticksUntilNextCycle;
    private boolean powered;

    public LogisticsModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
    }

    @Override
    public Item getItem() {
        return (Item)ModItems.LOGISTICS_MODULE.get();
    }

    public int getTicksSinceAction() {
        return this.ticksSinceAction;
    }

    public int getTicksSinceNotEnoughAir() {
        return this.ticksSinceNotEnoughAir;
    }

    @Override
    public double getWidth() {
        return 13.0;
    }

    @Override
    protected double getHeight() {
        return 4.5;
    }

    @Override
    public int getColorChannel() {
        return this.colorChannel;
    }

    @Override
    public void setColorChannel(int colorChannel) {
        this.colorChannel = colorChannel;
        this.setChanged();
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    public boolean hasPower() {
        return this.powered;
    }

    public void onUpdatePacket(int status, int colorChannel) {
        boolean bl = this.powered = status > 0;
        if (status == 2) {
            this.ticksSinceAction = 0;
        }
        if (status == 3) {
            this.ticksSinceNotEnoughAir = 0;
        }
        this.colorChannel = colorChannel;
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.putBoolean("powered", this.powered);
        nbt.putByte("colorChannel", (byte)this.colorChannel);
        return nbt;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.powered = nbt.getBoolean("powered");
        this.colorChannel = nbt.getByte("colorChannel");
    }

    public AbstractLogisticsFrameEntity getFrame() {
        ISemiBlock semiBlock;
        if (this.cachedFrame == null && (semiBlock = SemiblockTracker.getInstance().getSemiblock(this.getTube().getLevel(), this.getTube().getBlockPos().relative(this.dir), this.dir.getOpposite())) instanceof AbstractLogisticsFrameEntity) {
            this.cachedFrame = (AbstractLogisticsFrameEntity)semiBlock;
        }
        return this.cachedFrame;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        DyeColor color = DyeColor.getColor((ItemStack)player.getItemInHand(hand));
        if (color != null) {
            int colorId = color.getId();
            if (!player.level().isClientSide) {
                this.setColorChannel(colorId);
                NetworkHandler.sendToAllTracking((CustomPacketPayload)PacketUpdateLogisticsModule.create(this, 0), this.getTube());
                if (((Boolean)ConfigHelper.common().general.useUpDyesWhenColoring.get()).booleanValue() && !player.isCreative()) {
                    heldStack.shrink(1);
                }
            }
            return true;
        }
        return super.onActivated(player, hand);
    }

    @Override
    protected void tickCommon() {
        super.tickCommon();
        if (this.cachedFrame != null && !this.cachedFrame.isValid()) {
            this.cachedFrame = null;
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.powered != (double)this.getTube().getPressure() >= (Double)ConfigHelper.common().logistics.minPressure.get()) {
            this.powered = !this.powered;
            NetworkHandler.sendToAllTracking((CustomPacketPayload)PacketUpdateLogisticsModule.create(this, 0), this.getTube());
        }
        if (--this.ticksUntilNextCycle <= 0) {
            LogisticsManager manager = new LogisticsManager();
            Int2ObjectOpenHashMap frame2module = new Int2ObjectOpenHashMap();
            ModuleNetworkManager networkManager = ModuleNetworkManager.getInstance(this.getTube().nonNullLevel());
            for (AbstractTubeModule module : networkManager.getConnectedModules(this)) {
                LogisticsModule logistics;
                if (!module.isValid() || !(module instanceof LogisticsModule) || (logistics = (LogisticsModule)module).getColorChannel() != this.getColorChannel()) continue;
                logistics.ticksUntilNextCycle = 100;
                if (!logistics.hasPower() || logistics.getFrame() == null) continue;
                frame2module.put(logistics.getFrame().getId(), (Object)logistics);
                manager.addLogisticFrame(logistics.getFrame());
            }
            PriorityQueue<LogisticsManager.LogisticsTask> tasks = manager.getTasks(null, false);
            for (LogisticsManager.LogisticsTask task : tasks) {
                if (!task.isStillValid(task.transportingItem.isEmpty() ? task.transportingFluid : task.transportingItem)) continue;
                if (!task.transportingItem.isEmpty()) {
                    this.handleItems((LogisticsModule)frame2module.get(task.provider.getId()), (LogisticsModule)frame2module.get(task.requester.getId()), task);
                    continue;
                }
                this.handleFluids((LogisticsModule)frame2module.get(task.provider.getId()), (LogisticsModule)frame2module.get(task.requester.getId()), task);
            }
        }
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.ticksSinceAction >= 0) {
            ++this.ticksSinceAction;
            if (this.ticksSinceAction > 3) {
                this.ticksSinceAction = -1;
            }
        }
        if (this.ticksSinceNotEnoughAir >= 0) {
            ++this.ticksSinceNotEnoughAir;
            if (this.ticksSinceNotEnoughAir > 20) {
                this.ticksSinceNotEnoughAir = -1;
            }
        }
    }

    private void handleItems(LogisticsModule providingModule, LogisticsModule requestingModule, LogisticsManager.LogisticsTask task) {
        IOHelper.getInventoryForBlock(task.requester.getCachedTileEntity(), requestingModule.dir.getOpposite()).ifPresent(requestingHandler -> {
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)requestingHandler, (ItemStack)task.transportingItem, (boolean)true);
            if (remainder.getCount() != task.transportingItem.getCount()) {
                ItemStack toBeExtracted = task.transportingItem.copy();
                toBeExtracted.shrink(remainder.getCount());
                IOHelper.getInventoryForBlock(task.provider.getCachedTileEntity(), providingModule.dir.getOpposite()).ifPresent(providingHandler -> this.tryItemTransfer(providingModule, requestingModule, (IItemHandler)providingHandler, (IItemHandler)requestingHandler, toBeExtracted));
            }
        });
    }

    private void tryItemTransfer(LogisticsModule providingModule, LogisticsModule requestingModule, IItemHandler providingHandler, IItemHandler requestingHandler, ItemStack toTransfer) {
        ItemStack extractedStack = IOHelper.extract(providingHandler, toTransfer, IOHelper.ExtractCount.UP_TO, true, requestingModule.getFrame().isMatchNBT());
        if (extractedStack.isEmpty()) {
            return;
        }
        PNCCapabilities.getAirHandler(requestingModule.getTube()).ifPresent(receiverAirHandler -> {
            int airUsed = (int)((Double)ConfigHelper.common().logistics.itemTransportCost.get() * (double)extractedStack.getCount() * PneumaticCraftUtils.distBetween((Vec3i)providingModule.getTube().getBlockPos(), (Vec3i)requestingModule.getTube().getBlockPos()));
            if (airUsed > receiverAirHandler.getAir()) {
                double scaleBack = (double)receiverAirHandler.getAir() / (double)airUsed;
                extractedStack.setCount((int)((double)extractedStack.getCount() * scaleBack));
                airUsed = (int)((double)airUsed * scaleBack);
            }
            if (extractedStack.isEmpty()) {
                this.sendModuleUpdate(providingModule, false);
                this.sendModuleUpdate(requestingModule, false);
            } else {
                this.sendModuleUpdate(providingModule, true);
                this.sendModuleUpdate(requestingModule, true);
                receiverAirHandler.addAir(-airUsed);
                IOHelper.extract(providingHandler, extractedStack, IOHelper.ExtractCount.EXACT, false, requestingModule.getFrame().isMatchNBT());
                ItemHandlerHelper.insertItem((IItemHandler)requestingHandler, (ItemStack)extractedStack, (boolean)false);
                this.ticksUntilNextCycle = 20;
            }
        });
    }

    private void handleFluids(LogisticsModule providingModule, LogisticsModule requestingModule, LogisticsManager.LogisticsTask task) {
        IOHelper.getFluidHandlerForBlock(task.requester.getCachedTileEntity(), requestingModule.dir.getOpposite()).ifPresent(requestingHandler -> {
            int amountFilled = requestingHandler.fill(task.transportingFluid, IFluidHandler.FluidAction.SIMULATE);
            if (amountFilled > 0) {
                FluidStack drainingFluid = task.transportingFluid.copy();
                drainingFluid.setAmount(amountFilled);
                IOHelper.getFluidHandlerForBlock(task.provider.getCachedTileEntity(), providingModule.dir.getOpposite()).ifPresent(providingHandler -> this.tryFluidTransfer(providingModule, (IFluidHandler)providingHandler, requestingModule, (IFluidHandler)requestingHandler, drainingFluid));
            }
        });
    }

    private void tryFluidTransfer(LogisticsModule providingModule, IFluidHandler providingHandler, LogisticsModule requestingModule, IFluidHandler requestingHandler, FluidStack toTransfer) {
        FluidStack extractedFluid = providingHandler.drain(toTransfer, IFluidHandler.FluidAction.SIMULATE);
        if (extractedFluid.isEmpty()) {
            return;
        }
        PNCCapabilities.getAirHandler(requestingModule.getTube()).ifPresent(receiverAirHandler -> {
            double airUsed = (Double)ConfigHelper.common().logistics.fluidTransportCost.get() * (double)extractedFluid.getAmount() * PneumaticCraftUtils.distBetween((Vec3i)providingModule.getTube().getBlockPos(), (Vec3i)requestingModule.getTube().getBlockPos());
            if (airUsed > (double)receiverAirHandler.getAir()) {
                double scaleBack = (double)receiverAirHandler.getAir() / airUsed;
                toTransfer.setAmount((int)((double)extractedFluid.getAmount() * scaleBack));
                airUsed *= scaleBack;
            }
            if (toTransfer.isEmpty()) {
                this.sendModuleUpdate(providingModule, false);
                this.sendModuleUpdate(requestingModule, false);
            } else {
                this.sendModuleUpdate(providingModule, true);
                this.sendModuleUpdate(requestingModule, true);
                receiverAirHandler.addAir((int)(-airUsed));
                requestingHandler.fill(providingHandler.drain(toTransfer, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                this.ticksUntilNextCycle = 20;
            }
        });
    }

    private void sendModuleUpdate(LogisticsModule module, boolean enoughAir) {
        NetworkHandler.sendToAllTracking((CustomPacketPayload)PacketUpdateLogisticsModule.create(module, enoughAir ? 1 : 2), module.getTube());
    }

    @Override
    public void addInfo(List<Component> curInfo) {
        super.addInfo(curInfo);
        String status = this.ticksSinceAction >= 0 ? "pneumaticcraft.waila.logisticsModule.transporting" : (this.ticksSinceNotEnoughAir >= 0 ? "pneumaticcraft.waila.logisticsModule.notEnoughAir" : (this.hasPower() ? "pneumaticcraft.waila.logisticsModule.powered" : "pneumaticcraft.waila.logisticsModule.noPower"));
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.hud.msg.state", new Object[0]).append(": ").append((Component)PneumaticCraftUtils.xlate(status, new Object[0])));
    }

    @Override
    public boolean canUpgrade() {
        return false;
    }
}

