/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.extensions.IFriendlyByteBufExtension;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidFilter
implements INBTSerializable<CompoundTag> {
    private final NonNullList<FluidStack> fluidStacks;

    public FluidFilter() {
        this(9);
    }

    public FluidFilter(int size) {
        this.fluidStacks = NonNullList.withSize((int)size, (Object)FluidStack.EMPTY);
    }

    public FluidFilter(FriendlyByteBuf packetBuffer) {
        this.fluidStacks = NonNullList.create();
        int size = packetBuffer.readVarInt();
        for (int i = 0; i < size; ++i) {
            this.fluidStacks.add((Object)packetBuffer.readFluidStack());
        }
    }

    public int size() {
        return this.fluidStacks.size();
    }

    public void setFluid(int filterIndex, FluidStack stack) {
        if (filterIndex >= 0 && filterIndex < this.fluidStacks.size()) {
            this.fluidStacks.set(filterIndex, (Object)stack);
        }
    }

    public FluidStack getFluid(int filterIndex) {
        return filterIndex >= 0 && filterIndex < this.fluidStacks.size() ? (FluidStack)this.fluidStacks.get(filterIndex) : FluidStack.EMPTY;
    }

    public boolean matchFluid(Fluid fluid) {
        return this.fluidStacks.stream().anyMatch(filterStack -> !filterStack.isEmpty() && filterStack.getFluid() == fluid);
    }

    public void write(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeCollection(this.fluidStacks, IFriendlyByteBufExtension::writeFluidStack);
    }

    public CompoundTag serializeNBT() {
        return (CompoundTag)Util.make((Object)new CompoundTag(), t -> {
            ListTag list = new ListTag();
            for (int i = 0; i < this.fluidStacks.size(); ++i) {
                FluidStack f = (FluidStack)this.fluidStacks.get(i);
                if (f.isEmpty()) continue;
                CompoundTag t1 = new CompoundTag();
                t1.putInt("Slot", i);
                f.writeToNBT(t1);
                list.add((Object)t1);
            }
            t.put("fluids", (Tag)list);
        });
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.fluidStacks.replaceAll(ignored -> FluidStack.EMPTY);
        ListTag list = nbt.getList("fluids", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag t = list.getCompound(i);
            int slot = t.getInt("Slot");
            if (slot < 0 || slot >= this.fluidStacks.size()) continue;
            this.fluidStacks.set(slot, (Object)FluidStack.loadFluidStackFromNBT((CompoundTag)t));
        }
    }
}

