/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerInvWrapper;

public class FluidUtils {
    public static boolean tryFluidExtraction(IFluidHandler srcHandler, ItemStack destStack, NonNullList<ItemStack> returnedItems) {
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)destStack, (IFluidHandler)srcHandler, (int)1000, null, (boolean)true);
        if (result.isSuccess()) {
            returnedItems.add((Object)result.getResult());
            destStack.shrink(1);
            return true;
        }
        return false;
    }

    public static boolean tryFluidInsertion(IFluidHandler handler, ItemStack srcStack, NonNullList<ItemStack> returnedItems) {
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)srcStack, (IFluidHandler)handler, (int)1000, null, (boolean)true);
        if (result.isSuccess()) {
            returnedItems.add((Object)result.getResult());
            srcStack.shrink(1);
            return true;
        }
        return false;
    }

    public static boolean tryFluidInsertion(BlockEntity te, Direction face, Player player, InteractionHand hand) {
        return FluidUtils.doFluidInteraction(te, face, player, hand, true);
    }

    public static boolean tryFluidExtraction(BlockEntity te, Direction face, Player player, InteractionHand hand) {
        return FluidUtils.doFluidInteraction(te, face, player, hand, false);
    }

    private static boolean doFluidInteraction(BlockEntity te, Direction face, Player player, InteractionHand hand, boolean isInserting) {
        ItemStack stack = player.getItemInHand(hand);
        return FluidUtil.getFluidHandler((ItemStack)stack).map(stackHandler -> {
            if (IOHelper.getFluidHandlerForBlock(te, face).isPresent()) {
                if (stackHandler.getTanks() == 0) {
                    return false;
                }
                int capacity = stackHandler.getTankCapacity(0);
                return IOHelper.getFluidHandlerForBlock(te, face).map(handler -> {
                    FluidActionResult result;
                    PlayerInvWrapper invWrapper = new PlayerInvWrapper(player.getInventory());
                    FluidActionResult fluidActionResult = result = isInserting ? FluidUtils.tryEmptyContainerAndStow(player.getItemInHand(hand), handler, (IItemHandler)invWrapper, capacity, player, true) : FluidUtil.tryFillContainerAndStow((ItemStack)player.getItemInHand(hand), (IFluidHandler)handler, (IItemHandler)invWrapper, (int)capacity, (Player)player, (boolean)true);
                    if (result.isSuccess()) {
                        player.setItemInHand(hand, result.getResult());
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
            return false;
        }).orElse(false);
    }

    public static boolean isSourceFluidBlock(Level world, BlockPos pos) {
        return FluidUtils.isSourceFluidBlock(world, pos, null);
    }

    public static boolean isSourceFluidBlock(Level world, BlockPos pos, @Nullable Fluid fluid) {
        FluidState state = world.getFluidState(pos);
        return state.isSource() && fluid == null || state.getType() == fluid;
    }

    public static boolean isFlowingFluidBlock(Level world, BlockPos pos) {
        return FluidUtils.isFlowingFluidBlock(world, pos, null);
    }

    public static boolean isFlowingFluidBlock(Level world, BlockPos pos, @Nullable Fluid fluid) {
        FluidState state = world.getFluidState(pos);
        return !state.isEmpty() && !state.isSource() && (fluid == null || fluid == state.getType());
    }

    public static FluidStack tryPickupFluid(IFluidHandler fluidCap, Level world, BlockPos pos, boolean playSound, IFluidHandler.FluidAction action) {
        FluidStack transferred;
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (!(block instanceof BucketPickup)) {
            return FluidStack.EMPTY;
        }
        BucketPickup pickup = (BucketPickup)block;
        FluidState fluidState = state.getFluidState();
        Fluid fluid = fluidState.getType();
        if (fluid == Fluids.EMPTY || !fluid.isSource(fluidState)) {
            return FluidStack.EMPTY;
        }
        FluidTank tank = new FluidTank(1000);
        tank.setFluid(new FluidStack(fluid, 1000));
        FluidStack maybeSent = FluidUtil.tryFluidTransfer((IFluidHandler)fluidCap, (IFluidHandler)tank, (int)1000, (boolean)false);
        if (maybeSent.getAmount() != 1000) {
            return FluidStack.EMPTY;
        }
        boolean removeBlock = true;
        if (fluid == Fluids.WATER && ((Boolean)ConfigHelper.common().advanced.dontUpdateInfiniteWaterSources.get()).booleanValue()) {
            int n = 0;
            for (Direction d : DirectionUtil.HORIZONTALS) {
                if (world.getFluidState(pos.relative(d)).getType() != Fluids.WATER || ++n < 2) continue;
                removeBlock = false;
                break;
            }
        }
        if (removeBlock && action.execute()) {
            pickup.pickupBlock(null, (LevelAccessor)world, pos, state);
        }
        if (!(transferred = FluidUtil.tryFluidTransfer((IFluidHandler)fluidCap, (IFluidHandler)tank, (int)1000, (boolean)action.execute())).isEmpty() && action.execute() && playSound) {
            FluidUtils.playFillSound(world, pos, fluid);
        }
        return transferred;
    }

    public static boolean tryPourOutFluid(IFluidHandler handler, Level world, BlockPos pos, boolean playSound, boolean force, IFluidHandler.FluidAction action) {
        boolean isNotSolid;
        BlockState blockstate = world.getBlockState(pos);
        boolean isReplaceable = blockstate.canBeReplaced();
        boolean bl = isNotSolid = !blockstate.isSolid();
        if (!force && (FluidUtils.isSourceFluidBlock(world, pos) || !isReplaceable && !(blockstate.getBlock() instanceof LiquidBlockContainer))) {
            return false;
        }
        boolean didWork = false;
        FluidStack toPlace = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        if (toPlace.getAmount() >= 1000) {
            LiquidBlockContainer lbc;
            Fluid fluid = toPlace.getFluid();
            Block block = blockstate.getBlock();
            if (world.isEmptyBlock(pos) || isNotSolid || isReplaceable || block instanceof LiquidBlockContainer && (lbc = (LiquidBlockContainer)block).canPlaceLiquid(null, (BlockGetter)world, pos, blockstate, toPlace.getFluid())) {
                if (action.execute()) {
                    if (world.dimensionType().ultraWarm() && fluid.is(FluidTags.WATER)) {
                        FluidUtils.playEvaporationEffects(world, pos);
                    } else if (block instanceof LiquidBlockContainer) {
                        FluidState still;
                        FluidState fluidState = still = fluid instanceof FlowingFluid ? ((FlowingFluid)fluid).getSource(false) : fluid.defaultFluidState();
                        if (((LiquidBlockContainer)block).placeLiquid((LevelAccessor)world, pos, blockstate, still) && playSound) {
                            FluidUtils.playEmptySound(world, pos, fluid);
                        }
                    } else {
                        if (playSound) {
                            FluidUtils.playEmptySound(world, pos, fluid);
                        }
                        if (isNotSolid || isReplaceable) {
                            world.destroyBlock(pos, true);
                        }
                        world.setBlock(pos, fluid.defaultFluidState().createLegacyBlock(), 3);
                    }
                }
                didWork = true;
            }
        }
        if (didWork && action.execute()) {
            handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        }
        return didWork;
    }

    private static void playEmptySound(Level world, BlockPos pos, Fluid fluid) {
        SoundEvent soundevent = fluid.getFluidType().getSound(SoundActions.BUCKET_EMPTY);
        if (soundevent == null) {
            soundevent = fluid.is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
        }
        world.playSound(null, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void playFillSound(Level world, BlockPos pos, Fluid fluid) {
        SoundEvent soundEvent = fluid.getFluidType().getSound(SoundActions.BUCKET_FILL);
        if (soundEvent == null) {
            soundEvent = fluid.is(FluidTags.LAVA) ? SoundEvents.BUCKET_FILL_LAVA : SoundEvents.BUCKET_FILL;
        }
        world.playSound(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void playEvaporationEffects(Level world, BlockPos pos) {
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        world.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (world.random.nextFloat() - world.random.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    public static boolean matchFluid(FluidIngredient fluidIngredient, FluidStack fluidStack, boolean matchTags) {
        return fluidIngredient.testFluid(fluidStack);
    }

    public static boolean matchFluid(FluidIngredient fluidIngredient, Fluid fluid, boolean matchTags) {
        return fluidIngredient.testFluid(fluid);
    }

    @Nonnull
    private static FluidActionResult tryEmptyContainerAndStow(@Nonnull ItemStack container, IFluidHandler fluidDestination, IItemHandler inventory, int maxAmount, @Nullable Player player, boolean doDrain) {
        if (container.isEmpty()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.getAbilities().instabuild) {
            FluidActionResult emptiedReal = FluidUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.getCount() == 1) {
            FluidActionResult emptiedReal = FluidUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            ItemStack remainder;
            FluidActionResult emptiedSimulated = FluidUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)emptiedSimulated.getResult(), (boolean)true)).isEmpty() || player != null)) {
                FluidActionResult emptiedReal = FluidUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
                remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)emptiedReal.getResult(), (!doDrain ? 1 : 0) != 0);
                if (!remainder.isEmpty() && player != null && doDrain) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)remainder);
                }
                ItemStack containerCopy = container.copy();
                containerCopy.shrink(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    private static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidHandler fluidDestination, int maxAmount, @Nullable Player player, boolean doDrain) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return FluidUtil.getFluidHandler((ItemStack)containerCopy).map(containerFluidHandler -> {
            SoundEvent soundevent;
            FluidStack transfer = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)containerFluidHandler, (int)maxAmount, (boolean)doDrain);
            if (transfer.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            if (doDrain && player != null && (soundevent = transfer.getFluid().getFluidType().getSound(SoundActions.BUCKET_EMPTY)) != null) {
                player.level().playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }).orElse(FluidActionResult.FAILURE);
    }
}

