/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class JsonToNBTConverter {
    private final String jsonString;

    public JsonToNBTConverter(String jsonString) {
        this.jsonString = jsonString;
    }

    public CompoundTag convert() {
        JsonParser parser = new JsonParser();
        JsonElement el = parser.parse(this.jsonString);
        return JsonToNBTConverter.getTag((JsonObject)el);
    }

    public static CompoundTag getTag(JsonObject object) {
        CompoundTag nbt = new CompoundTag();
        block12: for (Map.Entry entry : object.entrySet()) {
            JsonObject keyObject = ((JsonElement)entry.getValue()).getAsJsonObject();
            int type = keyObject.get("type").getAsInt();
            JsonElement element = keyObject.get("value");
            switch (type) {
                case 1: {
                    nbt.putByte((String)entry.getKey(), (byte)element.getAsDouble());
                    continue block12;
                }
                case 2: {
                    nbt.putShort((String)entry.getKey(), (short)element.getAsDouble());
                    continue block12;
                }
                case 3: {
                    nbt.putInt((String)entry.getKey(), (int)element.getAsDouble());
                    continue block12;
                }
                case 4: {
                    nbt.putLong((String)entry.getKey(), (long)element.getAsDouble());
                    continue block12;
                }
                case 5: {
                    nbt.putFloat((String)entry.getKey(), (float)element.getAsDouble());
                    continue block12;
                }
                case 6: {
                    nbt.putDouble((String)entry.getKey(), element.getAsDouble());
                    continue block12;
                }
                case 8: {
                    nbt.putString((String)entry.getKey(), element.getAsString());
                    continue block12;
                }
                case 9: {
                    JsonArray array = element.getAsJsonArray();
                    ListTag tagList = new ListTag();
                    for (JsonElement e : array) {
                        if (e.isJsonObject()) {
                            tagList.add(tagList.size(), (Tag)JsonToNBTConverter.getTag(e.getAsJsonObject()));
                            continue;
                        }
                        tagList.add(tagList.size(), (Tag)StringTag.valueOf((String)e.getAsString()));
                    }
                    nbt.put((String)entry.getKey(), (Tag)tagList);
                    continue block12;
                }
                case 10: {
                    nbt.put((String)entry.getKey(), (Tag)JsonToNBTConverter.getTag(element.getAsJsonObject()));
                    continue block12;
                }
                case 11: {
                    JsonArray array = element.getAsJsonArray();
                    int[] intArray = new int[array.size()];
                    for (int i = 0; i < array.size(); ++i) {
                        intArray[i] = array.get(i).getAsInt();
                    }
                    nbt.put((String)entry.getKey(), (Tag)new IntArrayTag(intArray));
                    continue block12;
                }
            }
            throw new IllegalArgumentException("NBT type no " + type + " is not supported by the Json to NBT converter!");
        }
        return nbt;
    }
}

