/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NBTToJsonConverter {
    private final CompoundTag tag;

    public NBTToJsonConverter(CompoundTag tag) {
        this.tag = tag;
    }

    public String convert(boolean pretty) {
        JsonObject json = NBTToJsonConverter.getObject(this.tag);
        String jsonString = json.toString();
        JsonParser parser = new JsonParser();
        GsonBuilder builder = new GsonBuilder();
        if (pretty) {
            builder.setPrettyPrinting();
        }
        Gson gson = builder.create();
        JsonElement el = parser.parse(jsonString);
        return gson.toJson(el);
    }

    public static JsonObject getObject(CompoundTag tag) {
        Set keys = tag.getAllKeys();
        JsonObject jsonRoot = new JsonObject();
        for (String key : keys) {
            JsonArray array;
            JsonObject keyObject = new JsonObject();
            jsonRoot.add(key, (JsonElement)keyObject);
            Tag nbt = tag.get(key);
            keyObject.addProperty("type", (Number)nbt.getId());
            if (nbt instanceof CompoundTag) {
                keyObject.add("value", (JsonElement)NBTToJsonConverter.getObject((CompoundTag)nbt));
                continue;
            }
            if (nbt instanceof NumericTag) {
                keyObject.addProperty("value", (Number)((NumericTag)nbt).getAsDouble());
                continue;
            }
            if (nbt instanceof StringTag) {
                keyObject.addProperty("value", nbt.getAsString());
                continue;
            }
            if (nbt instanceof ListTag) {
                ListTag tagList = (ListTag)nbt;
                array = new JsonArray();
                for (int i = 0; i < tagList.size(); ++i) {
                    if (tagList.getElementType() == 10) {
                        array.add((JsonElement)NBTToJsonConverter.getObject(tagList.getCompound(i)));
                        continue;
                    }
                    if (tagList.getElementType() != 8) continue;
                    array.add((JsonElement)new JsonPrimitive(tagList.getString(i)));
                }
                keyObject.add("value", (JsonElement)array);
                continue;
            }
            if (nbt instanceof IntArrayTag) {
                IntArrayTag intArray = (IntArrayTag)nbt;
                array = new JsonArray();
                for (int i : intArray.getAsIntArray()) {
                    array.add((JsonElement)new JsonPrimitive((Number)i));
                }
                keyObject.add("value", (JsonElement)array);
                continue;
            }
            throw new IllegalArgumentException("NBT to JSON converter doesn't support the nbt tag: " + nbt.getId() + ", tag: " + nbt);
        }
        return jsonRoot;
    }
}

