/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class NBTUtils {
    public static void initNBTTagCompound(ItemStack itemStack) {
        if (!itemStack.hasTag()) {
            itemStack.setTag(new CompoundTag());
        }
    }

    public static boolean hasTag(ItemStack itemStack, String tagName) {
        return itemStack.getTag() != null && itemStack.getTag().contains(tagName);
    }

    public static void removeTag(ItemStack itemStack, String tagName) {
        if (itemStack.getTag() != null) {
            itemStack.getTag().remove(tagName);
        }
    }

    public static String getString(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.getTag().contains(tagName)) {
            NBTUtils.setString(itemStack, tagName, "");
        }
        return itemStack.getTag().getString(tagName);
    }

    public static void setString(ItemStack itemStack, String tagName, String tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.getTag().putString(tagName, tagValue);
    }

    public static boolean getBoolean(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.getTag().contains(tagName)) {
            NBTUtils.setBoolean(itemStack, tagName, false);
        }
        return itemStack.getTag().getBoolean(tagName);
    }

    public static void setBoolean(ItemStack itemStack, String tagName, boolean tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.getTag().putBoolean(tagName, tagValue);
    }

    public static byte getByte(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.getTag().contains(tagName)) {
            NBTUtils.setByte(itemStack, tagName, (byte)0);
        }
        return itemStack.getTag().getByte(tagName);
    }

    public static void setByte(ItemStack itemStack, String tagName, byte tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.getTag().putByte(tagName, tagValue);
    }

    public static short getShort(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.getTag().contains(tagName)) {
            NBTUtils.setShort(itemStack, tagName, (short)0);
        }
        return itemStack.getTag().getShort(tagName);
    }

    public static void setShort(ItemStack itemStack, String tagName, short tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.getTag().putShort(tagName, tagValue);
    }

    public static int getInteger(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.getTag().contains(tagName)) {
            NBTUtils.setInteger(itemStack, tagName, 0);
        }
        return itemStack.getTag().getInt(tagName);
    }

    public static void setInteger(ItemStack itemStack, String tagName, int tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.getTag().putInt(tagName, tagValue);
    }

    public static long getLong(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.getTag().contains(tagName)) {
            NBTUtils.setLong(itemStack, tagName, 0L);
        }
        return itemStack.getTag().getLong(tagName);
    }

    public static void setLong(ItemStack itemStack, String tagName, long tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.getTag().putLong(tagName, tagValue);
    }

    public static float getFloat(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.getTag().contains(tagName)) {
            NBTUtils.setFloat(itemStack, tagName, 0.0f);
        }
        return itemStack.getTag().getFloat(tagName);
    }

    public static void setFloat(ItemStack itemStack, String tagName, float tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.getTag().putFloat(tagName, tagValue);
    }

    public static double getDouble(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.getTag().contains(tagName)) {
            NBTUtils.setDouble(itemStack, tagName, 0.0);
        }
        return itemStack.getTag().getDouble(tagName);
    }

    public static void setDouble(ItemStack itemStack, String tagName, double tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.getTag().putDouble(tagName, tagValue);
    }

    public static CompoundTag getCompoundTag(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.getTag().contains(tagName)) {
            itemStack.getTag().put(tagName, (Tag)new CompoundTag());
        }
        return itemStack.getTag().getCompound(tagName);
    }

    public static void setCompoundTag(ItemStack itemStack, String tagName, Tag tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.getTag().put(tagName, tagValue);
    }

    public static void setPos(ItemStack stack, Vec3i vec) {
        NBTUtils.initNBTTagCompound(stack);
        NBTUtils.setPos(stack.getTag(), vec);
    }

    public static BlockPos getPos(ItemStack stack) {
        NBTUtils.initNBTTagCompound(stack);
        return NBTUtils.getPos(stack.getTag());
    }

    public static void setPos(CompoundTag tag, Vec3i vec) {
        tag.putInt("x", vec.getX());
        tag.putInt("y", vec.getY());
        tag.putInt("z", vec.getZ());
    }

    public static BlockPos getPos(CompoundTag tag) {
        return new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
    }

    public static boolean fromTag(CompoundTag tag, String name, boolean def) {
        return tag.contains(name) ? tag.getBoolean(name) : def;
    }

    public static int fromTag(CompoundTag tag, String name, int def) {
        return tag.contains(name) ? tag.getInt(name) : def;
    }

    public static String fromTag(CompoundTag tag, String name, String def) {
        return tag.contains(name) ? tag.getString(name) : def;
    }

    public static float fromTag(CompoundTag tag, String name, float def) {
        return tag.contains(name) ? tag.getFloat(name) : def;
    }

    public static ListTag serializeTextComponents(List<Component> textComponents) {
        ListTag l = new ListTag();
        textComponents.forEach(t -> l.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)t))));
        return l;
    }

    public static List<Component> deserializeTextComponents(ListTag l) {
        return l.stream().filter(nbt -> nbt instanceof StringTag).map(nbt -> Component.Serializer.fromJson((String)nbt.getAsString())).collect(Collectors.toList());
    }
}

