/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.Arrays;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDropItem;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetGoToLocation;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryExport;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryImport;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetLiquidExport;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetLiquidFilter;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetLiquidImport;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetSuicide;
import me.desht.pneumaticcraft.common.entity.drone.AmadroneEntity;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.DroneProgramBuilder;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.Validate;

public class ProgrammedDroneUtils {
    public static PathfinderMob deliverItemsAmazonStyle(GlobalPos gPos, ItemStack ... deliveredStacks) {
        ServerLevel world = GlobalPosHelper.getWorldForGlobalPos(gPos);
        if (world == null || world.isClientSide) {
            return null;
        }
        BlockPos deliveryPos = gPos.pos();
        Validate.isTrue((deliveredStacks.length > 0 && deliveredStacks.length <= 36 ? 1 : 0) != 0, (String)"You can only deliver between 0 & 36 stacks at once!", (Object[])new Object[0]);
        Arrays.stream(deliveredStacks).forEach(stack -> Validate.isTrue((!stack.isEmpty() ? 1 : 0) != 0, (String)"You can't supply an empty stack to be delivered!", (Object[])new Object[0]));
        AmadroneEntity drone = AmadroneEntity.makeAmadrone((Level)world, deliveryPos);
        DroneProgramBuilder builder = new DroneProgramBuilder();
        builder.add(new ProgWidgetStart(), new IProgWidget[0]);
        ProgWidgetInventoryExport inventoryExport = new ProgWidgetInventoryExport();
        inventoryExport.setSides(ISidedWidget.ALL_SIDES);
        builder.add(inventoryExport, ProgWidgetArea.fromPosition(deliveryPos));
        builder.add(new ProgWidgetDropItem(), ProgrammedDroneUtils.makeDropArea(deliveryPos, drone));
        builder.add(new ProgWidgetGoToLocation(), ProgWidgetArea.fromPosition(drone.blockPosition()));
        builder.add(new ProgWidgetSuicide(), new IProgWidget[0]);
        drone.progWidgets.addAll(builder.build());
        for (int i = 0; i < deliveredStacks.length; ++i) {
            drone.getInv().setStackInSlot(i, deliveredStacks[i].copy());
        }
        world.addFreshEntity((Entity)drone);
        return drone;
    }

    private static ProgWidgetArea makeDropArea(BlockPos deliveryPos, AmadroneEntity drone) {
        if (drone.isBlockValidPathfindBlock(deliveryPos)) {
            return ProgWidgetArea.fromPosition(deliveryPos);
        }
        ProgWidgetArea dropOffArea = null;
        for (Direction d : DirectionUtil.VALUES) {
            if (!drone.isBlockValidPathfindBlock(deliveryPos.relative(d))) continue;
            dropOffArea = ProgWidgetArea.fromPosition(deliveryPos.relative(d));
        }
        if (dropOffArea == null) {
            dropOffArea = ProgWidgetArea.fromPosition(deliveryPos);
            for (int i = 2; i < 10 && !drone.isBlockValidPathfindBlock(deliveryPos.relative(Direction.UP, i)); ++i) {
                dropOffArea.setPos(0, dropOffArea.getPos(0).orElseThrow().above());
            }
            BlockPos pos1 = dropOffArea.getPos(0).orElseThrow();
            if (!drone.isBlockValidPathfindBlock(pos1)) {
                dropOffArea.setPos(0, new BlockPos(pos1.getZ(), drone.world().getMaxBuildHeight() + 5, pos1.getZ()));
            }
        }
        return dropOffArea;
    }

    public static PathfinderMob deliverFluidAmazonStyle(GlobalPos gPos, FluidStack deliveredFluid) {
        ServerLevel world = GlobalPosHelper.getWorldForGlobalPos(gPos);
        BlockPos pos = gPos.pos();
        if (world == null || world.isClientSide) {
            return null;
        }
        Validate.notNull((Object)deliveredFluid, (String)"Can't deliver a null FluidStack", (Object[])new Object[0]);
        Validate.isTrue((deliveredFluid.getAmount() > 0 ? 1 : 0) != 0, (String)"Can't deliver a FluidStack with an amount of <= 0", (Object[])new Object[0]);
        AmadroneEntity drone = AmadroneEntity.makeAmadrone((Level)world, pos);
        DroneProgramBuilder builder = new DroneProgramBuilder();
        builder.add(new ProgWidgetStart(), new IProgWidget[0]);
        ProgWidgetLiquidExport liquidExport = new ProgWidgetLiquidExport();
        liquidExport.setSides(ISidedWidget.ALL_SIDES);
        builder.add(liquidExport, ProgWidgetArea.fromPosition(pos));
        builder.add(new ProgWidgetGoToLocation(), ProgWidgetArea.fromPosition(drone.blockPosition()));
        builder.add(new ProgWidgetSuicide(), new IProgWidget[0]);
        drone.progWidgets.addAll(builder.build());
        drone.getFluidTank().fill(deliveredFluid, IFluidHandler.FluidAction.EXECUTE);
        world.addFreshEntity((Entity)drone);
        return drone;
    }

    public static PathfinderMob retrieveItemsAmazonStyle(GlobalPos gPos, ItemStack ... queriedStacks) {
        ServerLevel world = GlobalPosHelper.getWorldForGlobalPos(gPos);
        BlockPos pos = gPos.pos();
        if (world == null || world.isClientSide) {
            return null;
        }
        Validate.isTrue((queriedStacks.length > 0 && queriedStacks.length <= 36 ? 1 : 0) != 0, (String)"Must retrieve between 1 & 36 itemstacks!", (Object[])new Object[0]);
        Arrays.stream(queriedStacks).forEach(stack -> Validate.isTrue((!stack.isEmpty() ? 1 : 0) != 0, (String)"Cannot retrieve an empty stack!", (Object[])new Object[0]));
        AmadroneEntity drone = AmadroneEntity.makeAmadrone((Level)world, pos);
        DroneProgramBuilder builder = new DroneProgramBuilder();
        builder.add(new ProgWidgetStart(), new IProgWidget[0]);
        for (ItemStack stack2 : queriedStacks) {
            ProgWidgetInventoryImport widgetImport = new ProgWidgetInventoryImport();
            widgetImport.setUseCount(true);
            widgetImport.setCount(stack2.getCount());
            ProgWidgetItemFilter filter = ProgWidgetItemFilter.withFilter(stack2);
            filter.useNBT = stack2.hasTag();
            builder.add(widgetImport, ProgWidgetArea.fromPosition(pos), filter);
        }
        builder.add(new ProgWidgetGoToLocation(), ProgWidgetArea.fromPosition(drone.blockPosition()));
        builder.add(new ProgWidgetSuicide(), new IProgWidget[0]);
        drone.progWidgets.addAll(builder.build());
        world.addFreshEntity((Entity)drone);
        return drone;
    }

    public static PathfinderMob retrieveFluidAmazonStyle(GlobalPos gPos, FluidStack queriedFluid) {
        ServerLevel world = GlobalPosHelper.getWorldForGlobalPos(gPos);
        BlockPos pos = gPos.pos();
        if (world == null || world.isClientSide) {
            return null;
        }
        Validate.notNull((Object)queriedFluid, (String)"Can't retrieve a null FluidStack", (Object[])new Object[0]);
        Validate.isTrue((queriedFluid.getAmount() > 0 ? 1 : 0) != 0, (String)"Can't retrieve a FluidStack with an amount of <= 0", (Object[])new Object[0]);
        AmadroneEntity drone = AmadroneEntity.makeAmadrone((Level)world, pos);
        DroneProgramBuilder builder = new DroneProgramBuilder();
        builder.add(new ProgWidgetStart(), new IProgWidget[0]);
        ProgWidgetLiquidImport liquidImport = new ProgWidgetLiquidImport();
        liquidImport.setUseCount(true);
        liquidImport.setCount(queriedFluid.getAmount());
        liquidImport.setSides(ISidedWidget.ALL_SIDES);
        builder.add(liquidImport, ProgWidgetArea.fromPosition(pos), ProgWidgetLiquidFilter.withFilter(queriedFluid.getFluid()));
        builder.add(new ProgWidgetGoToLocation(), ProgWidgetArea.fromPosition(drone.blockPosition()));
        builder.add(new ProgWidgetSuicide(), new IProgWidget[0]);
        drone.progWidgets.addAll(builder.build());
        world.addFreshEntity((Entity)drone);
        return drone;
    }
}

