/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.upgrade.IUpgradeItem;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.upgrades.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.common.upgrades.UpgradeCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.items.ItemStackHandler;

public class UpgradableItemUtils {
    public static final String NBT_CREATIVE = "CreativeUpgrade";
    public static final String NBT_UPGRADE_TAG = "UpgradeInventory";
    public static final int UPGRADE_INV_SIZE = 9;
    private static final String NBT_UPGRADE_CACHE_TAG = "UpgradeCache";

    public static void addUpgradeInformation(ItemStack iStack, List<Component> textList, TooltipFlag flag) {
        Map<PNCUpgrade, Integer> upgrades = UpgradableItemUtils.getUpgrades(iStack);
        if (upgrades.isEmpty()) {
            if (!ApplicableUpgradesDB.getInstance().getApplicableUpgrades(iStack.getItem()).isEmpty()) {
                textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.upgrades.empty", new Object[0]).withStyle(ChatFormatting.DARK_GREEN));
            }
        } else {
            textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.upgrades.not_empty", new Object[0]).withStyle(ChatFormatting.GREEN));
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            upgrades.forEach((upgrade, count) -> stacks.add(upgrade.getItemStack((int)count)));
            PneumaticCraftUtils.summariseItemStacks(textList, stacks, Component.literal((String)"\u2022 ").withStyle(ChatFormatting.DARK_GREEN));
        }
    }

    public static void setUpgrades(ItemStack stack, ItemStackHandler handler) {
        stack.getOrCreateTag().put(NBT_UPGRADE_TAG, (Tag)handler.serializeNBT());
        UpgradeCache cache = new UpgradeCache(() -> handler);
        Objects.requireNonNull(stack.getTag()).put(NBT_UPGRADE_CACHE_TAG, (Tag)cache.toNBT());
        PNCCapabilities.getAirHandler(stack).ifPresent(h -> {
            if (h.getPressure() > h.maxPressure()) {
                int maxAir = (int)((float)h.getVolume() * h.maxPressure());
                h.addAir(maxAir - h.getAir());
            }
        });
    }

    public static Map<PNCUpgrade, Integer> getUpgrades(ItemStack stack) {
        CompoundTag tag = UpgradableItemUtils.getSerializedUpgrades(stack);
        ListTag itemList = tag.getList("Items", 10);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < itemList.size(); ++i) {
            ItemStack upgradeStack = ItemStack.of((CompoundTag)itemList.getCompound(i));
            Item item = upgradeStack.getItem();
            if (!(item instanceof IUpgradeItem)) continue;
            IUpgradeItem upgradeItem = (IUpgradeItem)item;
            builder.put((Object)upgradeItem.getUpgradeType(), (Object)(upgradeItem.getUpgradeTier() * upgradeStack.getCount()));
        }
        return builder.build();
    }

    public static int getUpgradeCount(ItemStack stack, PNCUpgrade upgrade) {
        if (stack.getTag() != null) {
            UpgradableItemUtils.validateUpgradeCache(stack);
            CompoundTag subTag = Objects.requireNonNull(stack.getTag()).getCompound(NBT_UPGRADE_CACHE_TAG);
            String key = PneumaticCraftUtils.modDefaultedString(upgrade.getId());
            return subTag.getInt(key);
        }
        return 0;
    }

    public static IntList getUpgradeList(ItemStack stack, PNCUpgrade ... upgradeList) {
        IntArrayList res = new IntArrayList();
        if (stack.getTag() != null) {
            UpgradableItemUtils.validateUpgradeCache(stack);
            CompoundTag subTag = stack.getTag().getCompound(NBT_UPGRADE_CACHE_TAG);
            for (PNCUpgrade upgrade : upgradeList) {
                String key = PneumaticCraftUtils.modDefaultedString(upgrade.getId());
                res.add(subTag.getInt(key));
            }
        }
        return IntLists.unmodifiable((IntList)res);
    }

    public static boolean hasCreativeUpgrade(ItemStack stack) {
        return stack.getTag() != null && stack.getTag().getBoolean(NBT_CREATIVE);
    }

    private static void validateUpgradeCache(ItemStack stack) {
        if (Objects.requireNonNull(stack.getTag()).contains(NBT_UPGRADE_TAG) && !stack.getTag().contains(NBT_UPGRADE_CACHE_TAG)) {
            ItemStackHandler handler = new ItemStackHandler(9);
            CompoundTag tag = UpgradableItemUtils.getSerializedUpgrades(stack);
            if (!tag.isEmpty()) {
                handler.deserializeNBT(tag);
            }
            UpgradeCache cache = new UpgradeCache(() -> handler);
            Objects.requireNonNull(stack.getTag()).put(NBT_UPGRADE_CACHE_TAG, (Tag)cache.toNBT());
        }
    }

    private static CompoundTag getSerializedUpgrades(ItemStack stack) {
        if (stack.getTag() == null) {
            return new CompoundTag();
        }
        if (stack.getTag().contains("BlockEntityTag")) {
            return Objects.requireNonNull(stack.getTagElement("BlockEntityTag")).getCompound(NBT_UPGRADE_TAG);
        }
        return stack.getTag().getCompound(NBT_UPGRADE_TAG);
    }
}

