/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.playerfilter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;

public record BiomeMatcher(List<TagKey<Biome>> tags) implements IPlayerMatcher
{
    private static final Codec<BiomeMatcher> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)TagKey.codec((ResourceKey)Registries.BIOME).listOf().fieldOf("biomes").forGetter(BiomeMatcher::tags)).apply((Applicative)builder, BiomeMatcher::new));

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeCollection(this.tags, (buf, biomeTagKey) -> buf.writeResourceLocation(biomeTagKey.location()));
    }

    @Override
    public IPlayerMatcher.MatcherType<?> getType() {
        return BiomeMatcherType.INSTANCE;
    }

    @Override
    public void addDescription(Player player, List<Component> tooltip) {
        if (!this.tags.isEmpty()) {
            List<Component> items = this.tags.stream().map(tag -> Component.literal((String)tag.location().toString())).collect(Collectors.toList());
            this.standardTooltip(player, tooltip, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.biomes", new Object[0]), items);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(Player playerEntity) {
        if (this.tags.isEmpty()) return true;
        if (!playerEntity.level().getBiome(playerEntity.blockPosition()).tags().anyMatch(this.tags::contains)) return false;
        return true;
    }

    public static enum BiomeMatcherType implements IPlayerMatcher.MatcherType<BiomeMatcher>
    {
        INSTANCE;

        private static final ResourceLocation ID;

        @Override
        public ResourceLocation getId() {
            return ID;
        }

        @Override
        public BiomeMatcher fromNetwork(FriendlyByteBuf buf) {
            return new BiomeMatcher(buf.readList(buf1 -> TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)buf1.readResourceLocation())));
        }

        @Override
        public Codec<BiomeMatcher> codec() {
            return CODEC;
        }

        static {
            ID = PneumaticRegistry.RL("biomes");
        }
    }
}

