/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.playerfilter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record DimensionMatcher(List<ResourceLocation> dimensionIds) implements IPlayerMatcher
{
    public static final Codec<DimensionMatcher> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.listOf().fieldOf("dimensions").forGetter(DimensionMatcher::dimensionIds)).apply((Applicative)inst, DimensionMatcher::new));

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeCollection(this.dimensionIds, FriendlyByteBuf::writeResourceLocation);
    }

    @Override
    public IPlayerMatcher.MatcherType<?> getType() {
        return DimensionMatcherType.INSTANCE;
    }

    @Override
    public void addDescription(Player player, List<Component> tooltip) {
        if (!this.dimensionIds.isEmpty()) {
            List<Component> items = this.dimensionIds.stream().map(id -> Component.literal((String)id.toString())).collect(Collectors.toList());
            this.standardTooltip(player, tooltip, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.dimensions", new Object[0]), items);
        }
    }

    @Override
    public boolean test(Player playerEntity) {
        return this.dimensionIds.isEmpty() || this.dimensionIds.contains(playerEntity.level().dimension().location());
    }

    public static enum DimensionMatcherType implements IPlayerMatcher.MatcherType<DimensionMatcher>
    {
        INSTANCE;

        private static final ResourceLocation ID;

        @Override
        public ResourceLocation getId() {
            return ID;
        }

        @Override
        public DimensionMatcher fromNetwork(FriendlyByteBuf buf) {
            return new DimensionMatcher(buf.readList(FriendlyByteBuf::readResourceLocation));
        }

        @Override
        public Codec<DimensionMatcher> codec() {
            return CODEC;
        }

        static {
            ID = PneumaticRegistry.RL("dimensions");
        }
    }
}

