/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.playerfilter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.misc.IPlayerFilter;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.util.playerfilter.PlayerMatcherTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record PlayerFilter(Op op, List<IPlayerMatcher> matchers) implements IPlayerFilter
{
    public static final Codec<IPlayerMatcher> MATCHER_CODEC = PlayerMatcherTypes.CODEC.dispatch("type", IPlayerMatcher::getType, IPlayerMatcher.MatcherType::codec);
    public static final Codec<PlayerFilter> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Op.CODEC.fieldOf("op").forGetter(PlayerFilter::op), (App)MATCHER_CODEC.listOf().fieldOf("matchers").forGetter(PlayerFilter::matchers)).apply((Applicative)inst, PlayerFilter::new));
    public static final PlayerFilter YES = new PlayerFilter(Op.YES, List.of());
    public static final PlayerFilter NO = new PlayerFilter(Op.NO, List.of());

    public static PlayerFilter fromNetwork(FriendlyByteBuf buffer) {
        Op op = (Op)buffer.readEnum(Op.class);
        int nMatchers = buffer.readVarInt();
        ArrayList<IPlayerMatcher> list = new ArrayList<IPlayerMatcher>();
        for (int i = 0; i < nMatchers; ++i) {
            ResourceLocation id = buffer.readResourceLocation();
            list.add((IPlayerMatcher)((IPlayerMatcher.MatcherType)PlayerMatcherTypes.matcherTypes.get((Object)id)).fromNetwork(buffer));
        }
        return new PlayerFilter(op, list);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.op);
        buffer.writeVarInt(this.matchers.size());
        this.matchers.forEach(matcher -> {
            buffer.writeResourceLocation(matcher.getType().getId());
            matcher.toNetwork(buffer);
        });
    }

    @Override
    public boolean isReal() {
        return !this.op.isFake();
    }

    @Override
    public boolean matchAll() {
        return this.op == Op.AND;
    }

    @Override
    public boolean test(Player player) {
        return switch (this.op) {
            default -> throw new IncompatibleClassChangeError();
            case Op.YES -> true;
            case Op.NO -> false;
            case Op.OR -> this.matchers.stream().anyMatch(matcher -> matcher.test(player));
            case Op.AND -> this.matchers.stream().allMatch(matcher -> matcher.test(player));
        };
    }

    @Override
    public void getDescription(Player player, List<Component> tooltip) {
        if (this.isReal()) {
            this.matchers.forEach(matcher -> matcher.addDescription(player, tooltip));
        }
    }

    @Override
    public String toString() {
        String delimiter = " " + this.op.toString() + " ";
        return "[" + this.matchers.stream().map(Object::toString).collect(Collectors.joining(delimiter)) + "]";
    }

    public static enum Op {
        YES,
        NO,
        AND,
        OR;

        public static final Codec<Op> CODEC;

        public boolean isFake() {
            return this == YES || this == NO;
        }

        static {
            CODEC = new PrimitiveCodec<Op>(){

                public <T> DataResult<Op> read(DynamicOps<T> ops, T input) {
                    try {
                        return ops.getStringValue(input).map(Op::valueOf);
                    }
                    catch (IllegalArgumentException e) {
                        return DataResult.error(() -> "invalid value: " + input);
                    }
                }

                public <T> T write(DynamicOps<T> ops, Op value) {
                    return (T)ops.createString(value.name());
                }
            };
        }
    }
}

