/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.playerfilter;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.playerfilter.BiomeMatcher;
import me.desht.pneumaticcraft.common.util.playerfilter.DimensionMatcher;
import net.minecraft.resources.ResourceLocation;

public class PlayerMatcherTypes {
    static final BiMap<ResourceLocation, IPlayerMatcher.MatcherType<?>> matcherTypes = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
    public static final Codec<IPlayerMatcher.MatcherType<?>> CODEC = Codec.STRING.flatXmap(key -> Optional.ofNullable((IPlayerMatcher.MatcherType)matcherTypes.get((Object)PneumaticCraftUtils.modDefaultedRL(key))).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "unknown matcher type: " + key)), matcherType -> Optional.ofNullable((ResourceLocation)matcherTypes.inverse().get(matcherType)).map(resLoc -> DataResult.success((Object)PneumaticCraftUtils.modDefaultedString(resLoc))).orElseGet(() -> DataResult.error(() -> "unknown registry element: " + matcherType)));

    public static void registerDefaultMatchers() {
        PlayerMatcherTypes.registerMatcher(DimensionMatcher.DimensionMatcherType.INSTANCE);
        PlayerMatcherTypes.registerMatcher(BiomeMatcher.BiomeMatcherType.INSTANCE);
    }

    public static void registerMatcher(IPlayerMatcher.MatcherType<?> matcher) {
        matcherTypes.put((Object)matcher.getId(), matcher);
    }

    public static IPlayerMatcher.MatcherType<?> getMatcher(ResourceLocation id) {
        return (IPlayerMatcher.MatcherType)matcherTypes.get((Object)id);
    }
}

