/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.variables;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class GlobalVariableManager
extends SavedData {
    public static final int MAX_VARIABLE_LEN = 64;
    private static final String DATA_KEY = "PneumaticCraftGlobalVariables";
    private static final GlobalVariableManager CLIENT_INSTANCE = new GlobalVariableManager();
    private static ServerLevel overworld;
    private final Map<String, BlockPos> globalVars = new HashMap<String, BlockPos>();
    private final Map<String, ItemStack> globalItemVars = new HashMap<String, ItemStack>();
    private final Table<UUID, String, BlockPos> playerVars = HashBasedTable.create();
    private final Table<UUID, String, ItemStack> playerItemVars = HashBasedTable.create();

    public static GlobalVariableManager getInstance() {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            return CLIENT_INSTANCE;
        }
        return (GlobalVariableManager)GlobalVariableManager.getOverworld().getDataStorage().computeIfAbsent(new SavedData.Factory(GlobalVariableManager::new, GlobalVariableManager::load), DATA_KEY);
    }

    private GlobalVariableManager() {
    }

    private static ServerLevel getOverworld() {
        if (overworld == null && (overworld = ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD)) == null) {
            throw new IllegalStateException("Overworld not initialized!");
        }
        return overworld;
    }

    public static GlobalVariableManager load(CompoundTag tag) {
        GlobalVariableManager gvm = new GlobalVariableManager();
        gvm.readFromNBT(tag);
        return gvm;
    }

    boolean hasPos(String varName) {
        return this.globalVars.containsKey(varName);
    }

    boolean hasPos(UUID ownerUUID, String varName) {
        return this.playerVars.contains((Object)ownerUUID, (Object)varName);
    }

    BlockPos getPos(String varName) {
        return this.globalVars.getOrDefault(varName, BlockPos.ZERO);
    }

    BlockPos getPos(UUID ownerUUID, String varName) {
        BlockPos pos = (BlockPos)this.playerVars.get((Object)ownerUUID, (Object)varName);
        return pos == null ? BlockPos.ZERO : pos;
    }

    void setPos(String varName, BlockPos pos) {
        if (!varName.isEmpty()) {
            if (pos == null) {
                this.globalVars.remove(varName);
            } else {
                this.globalVars.put(varName, pos);
            }
            this.setDirty();
        }
    }

    void setPos(UUID ownerUUID, String varName, BlockPos coord) {
        if (!varName.isEmpty()) {
            if (coord == null) {
                this.playerVars.remove((Object)ownerUUID, (Object)varName);
            } else {
                this.playerVars.put((Object)ownerUUID, (Object)varName, (Object)coord);
            }
            this.setDirty();
        }
    }

    void setStack(String varName, ItemStack item) {
        if (!varName.isEmpty()) {
            if (item.isEmpty()) {
                this.globalItemVars.remove(varName);
            } else {
                this.globalItemVars.put(varName, item);
            }
            this.setDirty();
        }
    }

    void setStack(UUID ownerUUID, String varName, ItemStack item) {
        if (!varName.isEmpty()) {
            if (item.isEmpty()) {
                this.playerItemVars.remove((Object)ownerUUID, (Object)varName);
            } else {
                this.playerItemVars.put((Object)ownerUUID, (Object)varName, (Object)item);
            }
            this.setDirty();
        }
    }

    boolean hasStack(String varName) {
        return this.globalItemVars.containsKey(varName);
    }

    boolean hasStack(UUID ownerUUID, String varName) {
        return this.playerItemVars.contains((Object)ownerUUID, (Object)varName);
    }

    ItemStack getStack(String varName) {
        return this.globalItemVars.getOrDefault(varName, ItemStack.EMPTY);
    }

    ItemStack getStack(UUID ownerUUID, String varName) {
        ItemStack stack = (ItemStack)this.playerItemVars.get((Object)ownerUUID, (Object)varName);
        return stack == null ? ItemStack.EMPTY : stack;
    }

    private void readFromNBT(CompoundTag tag) {
        this.globalVars.clear();
        this.globalItemVars.clear();
        this.playerVars.clear();
        this.playerItemVars.clear();
        this.globalVars.putAll(this.readPosList(tag.getList("globalVars", 10)));
        this.globalItemVars.putAll(this.readItemList(tag.getList("globalItemVars", 10)));
        CompoundTag playerPos = tag.getCompound("playerVars");
        for (String id : playerPos.getAllKeys()) {
            this.readPosList(playerPos.getList(id, 10)).forEach((k, v) -> this.playerVars.put((Object)UUID.fromString(id), k, v));
        }
        CompoundTag playerItems = tag.getCompound("playerItemVars");
        for (String id : playerItems.getAllKeys()) {
            this.readItemList(playerItems.getList(id, 10)).forEach((k, v) -> this.playerItemVars.put((Object)UUID.fromString(id), k, v));
        }
    }

    public CompoundTag save(CompoundTag tag) {
        tag.put("globalVars", (Tag)this.writePosList(this.globalVars));
        tag.put("globalItemVars", (Tag)this.writeItemList(this.globalItemVars));
        CompoundTag playerPos = new CompoundTag();
        for (UUID uuid : this.playerVars.rowKeySet()) {
            playerPos.put(uuid.toString(), (Tag)this.writePosList(this.playerVars.row((Object)uuid)));
        }
        tag.put("playerVars", (Tag)playerPos);
        CompoundTag playerItems = new CompoundTag();
        for (UUID uuid : this.playerItemVars.rowKeySet()) {
            playerItems.put(uuid.toString(), (Tag)this.writeItemList(this.playerItemVars.row((Object)uuid)));
        }
        tag.put("playerItemVars", (Tag)playerItems);
        return tag;
    }

    private Map<String, BlockPos> readPosList(ListTag list) {
        HashMap<String, BlockPos> map = new HashMap<String, BlockPos>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag t = list.getCompound(i);
            map.put(t.getString("varName"), new BlockPos(t.getInt("x"), t.getInt("y"), t.getInt("z")));
        }
        return map;
    }

    private ListTag writePosList(Map<String, BlockPos> map) {
        ListTag list = new ListTag();
        map.forEach((key, pos) -> {
            CompoundTag t = new CompoundTag();
            t.putString("varName", key);
            t.putInt("x", pos.getX());
            t.putInt("y", pos.getY());
            t.putInt("z", pos.getZ());
            list.add((Object)t);
        });
        return list;
    }

    private Map<String, ItemStack> readItemList(ListTag list) {
        HashMap<String, ItemStack> map = new HashMap<String, ItemStack>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag t = list.getCompound(i);
            map.put(t.getString("varName"), ItemStack.of((CompoundTag)t.getCompound("item")));
        }
        return map;
    }

    private ListTag writeItemList(Map<String, ItemStack> map) {
        ListTag list = new ListTag();
        for (Map.Entry<String, ItemStack> entry : map.entrySet()) {
            CompoundTag t = new CompoundTag();
            t.putString("varName", entry.getKey());
            CompoundTag itemTag = new CompoundTag();
            entry.getValue().save(itemTag);
            t.put("item", (Tag)itemTag);
            list.add((Object)t);
        }
        return list;
    }

    public Collection<String> getAllActiveVariableNames(Player player) {
        HashSet<String> varNames = new HashSet<String>();
        varNames.addAll(this.globalVars.keySet().stream().filter(s -> !s.isEmpty()).map(s -> "%" + s).toList());
        varNames.addAll(this.globalItemVars.keySet().stream().filter(s -> !s.isEmpty()).map(s -> "%" + s).toList());
        if (player != null) {
            varNames.addAll(this.playerVars.row((Object)player.getUUID()).keySet().stream().filter(s -> !s.isEmpty()).map(s -> "#" + s).toList());
            varNames.addAll(this.playerItemVars.row((Object)player.getUUID()).keySet().stream().filter(s -> !s.isEmpty()).map(s -> "#" + s).toList());
        }
        return varNames;
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onServerStarting(ServerAboutToStartEvent event) {
            overworld = null;
        }
    }
}

