/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModBlockTagsProvider
extends BlockTagsProvider {
    public ModBlockTagsProvider(DataGenerator generator, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), lookupProvider, "pneumaticcraft", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider pProvider) {
        this.createAndAppend(PneumaticCraftTags.Blocks.REINFORCED_STONE, (TagKey<Block>)Tags.Blocks.STONE, new Supplier[]{ModBlocks.REINFORCED_STONE});
        this.createAndAppend(PneumaticCraftTags.Blocks.REINFORCED_STONE_BRICKS, (TagKey<Block>)BlockTags.STONE_BRICKS, new Supplier[]{ModBlocks.REINFORCED_BRICKS});
        this.createAndAppend(PneumaticCraftTags.Blocks.WALLS, (TagKey<Block>)BlockTags.WALLS, new Supplier[]{ModBlocks.REINFORCED_BRICK_WALL});
        this.createAndAppend(PneumaticCraftTags.Blocks.SLABS, (TagKey<Block>)BlockTags.SLABS, new Supplier[]{ModBlocks.REINFORCED_BRICK_SLAB, ModBlocks.REINFORCED_STONE_SLAB});
        this.createAndAppend(PneumaticCraftTags.Blocks.STAIRS, (TagKey<Block>)BlockTags.STAIRS, new Supplier[]{ModBlocks.REINFORCED_BRICK_STAIRS});
        this.createAndAppend(PneumaticCraftTags.Blocks.COMPRESSED_STONE, (TagKey<Block>)Tags.Blocks.STONE, new Supplier[]{ModBlocks.COMPRESSED_STONE});
        this.createAndAppend(PneumaticCraftTags.Blocks.COMPRESSED_STONE_BRICKS, (TagKey<Block>)BlockTags.STONE_BRICKS, new Supplier[]{ModBlocks.COMPRESSED_BRICKS});
        this.createAndAppend(PneumaticCraftTags.Blocks.WALLS, (TagKey<Block>)BlockTags.WALLS, new Supplier[]{ModBlocks.COMPRESSED_BRICK_WALL});
        this.createAndAppend(PneumaticCraftTags.Blocks.SLABS, (TagKey<Block>)BlockTags.SLABS, new Supplier[]{ModBlocks.COMPRESSED_BRICK_SLAB, ModBlocks.COMPRESSED_STONE_SLAB});
        this.createAndAppend(PneumaticCraftTags.Blocks.STAIRS, (TagKey<Block>)BlockTags.STAIRS, new Supplier[]{ModBlocks.COMPRESSED_BRICK_STAIRS});
        this.createAndAppend(PneumaticCraftTags.Blocks.DOORS, (TagKey<Block>)BlockTags.DOORS, new Supplier[]{ModBlocks.PNEUMATIC_DOOR});
        this.createAndAppend(PneumaticCraftTags.Blocks.CHESTS, (TagKey<Block>)Tags.Blocks.CHESTS, new Supplier[]{ModBlocks.SMART_CHEST, ModBlocks.REINFORCED_CHEST});
        this.createAndAppend(PneumaticCraftTags.Blocks.STORAGE_BLOCKS_COMPRESSED_IRON, (TagKey<Block>)Tags.Blocks.STORAGE_BLOCKS, new Supplier[]{ModBlocks.COMPRESSED_IRON_BLOCK});
        this.createTag(PneumaticCraftTags.Blocks.PLASTIC_BRICKS, ModBlocks.PLASTIC_BRICKS.toArray(new Supplier[0]));
        this.createTag(PneumaticCraftTags.Blocks.SMOOTH_PLASTIC_BRICKS, ModBlocks.SMOOTH_PLASTIC_BRICKS.toArray(new Supplier[0]));
        this.createTag(PneumaticCraftTags.Blocks.WALL_LAMPS, ModBlocks.WALL_LAMPS.toArray(new Supplier[0]));
        this.createTag(PneumaticCraftTags.Blocks.WALL_LAMPS_INVERTED, ModBlocks.WALL_LAMPS_INVERTED.toArray(new Supplier[0]));
        this.createTag(PneumaticCraftTags.Blocks.FLUID_TANKS, new Supplier[]{ModBlocks.TANK_SMALL, ModBlocks.TANK_MEDIUM, ModBlocks.TANK_LARGE, ModBlocks.TANK_HUGE});
        this.createTag(PneumaticCraftTags.Blocks.BLOCK_TRACKER_MISC, () -> Blocks.TNT, () -> Blocks.TRIPWIRE, () -> Blocks.BEE_NEST, () -> Blocks.INFESTED_CHISELED_STONE_BRICKS, () -> Blocks.INFESTED_CRACKED_STONE_BRICKS, () -> Blocks.INFESTED_COBBLESTONE, () -> Blocks.INFESTED_STONE, () -> Blocks.INFESTED_MOSSY_STONE_BRICKS, () -> Blocks.INFESTED_STONE_BRICKS);
        this.createTag(PneumaticCraftTags.Blocks.PROBE_TARGET, new Supplier[0]);
        this.tag(Tags.Blocks.ORES);
        this.tag(BlockTags.LOGS);
        this.tag(PneumaticCraftTags.Blocks.JACKHAMMER_ORES).addTag(Tags.Blocks.ORES).addTag(BlockTags.LOGS);
        this.tag(PneumaticCraftTags.Blocks.ELECTROSTATIC_GRID).add((Object)Blocks.IRON_BARS);
        ModBlocks.BLOCKS.getEntries().forEach(ro -> {
            Block block = (Block)ro.get();
            if (!(block instanceof LiquidBlock) && !(block instanceof AirBlock)) {
                this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)block);
                this.tag(BlockTags.NEEDS_IRON_TOOL).add((Object)block);
            }
        });
    }

    @SafeVarargs
    private <T> T[] resolveAll(IntFunction<T[]> creator, Supplier<? extends T> ... suppliers) {
        return Arrays.stream(suppliers).map(Supplier::get).toArray(creator);
    }

    @SafeVarargs
    private void createTag(TagKey<Block> tag, Supplier<? extends Block> ... blocks) {
        this.tag(tag).add((Object[])this.resolveAll(Block[]::new, blocks));
    }

    @SafeVarargs
    private void appendToTag(TagKey<Block> tag, TagKey<Block> ... toAppend) {
        this.tag(tag).addTags(toAppend);
    }

    @SafeVarargs
    private void createAndAppend(TagKey<Block> tag, TagKey<Block> to, Supplier<? extends Block> ... blocks) {
        this.createTag(tag, blocks);
        this.appendToTag(to, tag);
    }

    public String getName() {
        return "PneumaticCraft Block Tags";
    }
}

