/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.loot.LootFunc;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ModLootTablesProvider
extends LootTableProvider {
    public ModLootTablesProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn.getPackOutput(), Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTablePNC::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(MechanicVillagerChestLootProvider::new, LootContextParamSets.CHEST), new LootTableProvider.SubProviderEntry(CustomDungeonLootProvider::new, LootContextParamSets.CHEST)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationresults) {
    }

    private static class CustomDungeonLootProvider
    implements LootTableSubProvider {
        private CustomDungeonLootProvider() {
        }

        public void generate(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            LootPool.Builder commonPool = LootPool.lootPool();
            commonPool.setRolls((NumberProvider)ConstantValue.exactly((float)3.0f)).add(this.createEntry((ItemLike)ModItems.COMPRESSED_IRON_INGOT.get(), 10, 1, 3)).add(this.createEntry((ItemLike)ModBlocks.COMPRESSED_STONE.get(), 10, 5, 10)).add(this.createEntry((ItemLike)ModItems.LOGISTICS_CORE.get(), 3, 1, 1)).add(this.createEntry((ItemLike)ModBlocks.PRESSURE_TUBE.get(), 3, 8, 8)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(20));
            LootTable.Builder commonTable = LootTable.lootTable();
            commonTable.withPool(commonPool);
            consumer.accept(PneumaticRegistry.RL("custom/common_dungeon_loot"), commonTable);
            LootPool.Builder uncommonPool = LootPool.lootPool();
            uncommonPool.setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add(this.createEntry((ItemLike)ModItems.VORTEX_CANNON.get(), 1, 1, 1)).add(this.createEntry((ItemLike)ModItems.SPAWNER_AGITATOR.get(), 1, 1, 1)).add(this.createEntry((ItemLike)ModItems.COMPRESSED_IRON_BOOTS.get(), 1, 1, 1)).add(this.createEntry((ItemLike)ModItems.COMPRESSED_IRON_LEGGINGS.get(), 1, 1, 1)).add(this.createEntry((ItemLike)ModItems.COMPRESSED_IRON_CHESTPLATE.get(), 1, 1, 1)).add(this.createEntry((ItemLike)ModItems.COMPRESSED_IRON_HELMET.get(), 1, 1, 1)).add(this.createEntry((ItemLike)ModItems.TRANSISTOR.get(), 1, 1, 4)).add(this.createEntry((ItemLike)ModItems.CAPACITOR.get(), 1, 1, 4)).add(this.createEntry((ItemLike)ModItems.PNEUMATIC_CYLINDER.get(), 1, 2, 3)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(10));
            LootTable.Builder uncommonTable = LootTable.lootTable();
            uncommonTable.withPool(uncommonPool);
            consumer.accept(PneumaticRegistry.RL("custom/uncommon_dungeon_loot"), uncommonTable);
            LootPool.Builder rarePool = LootPool.lootPool();
            rarePool.setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(this.createEntry((ItemLike)ModItems.STOP_WORM.get(), 1, 1, 1)).add(this.createEntry((ItemLike)ModItems.NUKE_VIRUS.get(), 1, 1, 1)).add(this.createEntry((ItemLike)ModItems.GUN_AMMO_AP.get(), 1, 1, 1)).add(this.ammo((ItemLike)ModItems.GUN_AMMO_FREEZING.get())).add(this.ammo((ItemLike)ModItems.GUN_AMMO_WEIGHTED.get())).add(this.ammo((ItemLike)ModItems.GUN_AMMO_INCENDIARY.get())).add(this.ammo((ItemLike)ModItems.GUN_AMMO_EXPLOSIVE.get())).add(this.createEntry((ItemLike)ModItems.PROGRAMMING_PUZZLE.get(), 1, 4, 12)).add(this.createEntry((ItemLike)ModItems.MICROMISSILES.get(), 1, 1, 1)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(20));
            LootTable.Builder rareTable = LootTable.lootTable();
            rareTable.withPool(rarePool);
            consumer.accept(PneumaticRegistry.RL("custom/rare_dungeon_loot"), rareTable);
        }

        private LootPoolEntryContainer.Builder<?> ammo(ItemLike item) {
            return this.createEntry(new ItemStack(item), 1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment());
        }

        private LootPoolEntryContainer.Builder<?> createEntry(ItemLike item, int weight, int min, int max) {
            return this.createEntry(new ItemStack(item), weight).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max)));
        }

        private LootPoolSingletonContainer.Builder<?> createEntry(ItemStack item, int weight) {
            LootPoolSingletonContainer.Builder ret = LootItem.lootTableItem((ItemLike)item.getItem()).setWeight(weight);
            if (item.hasTag()) {
                ret.apply((LootItemFunction.Builder)SetNbtFunction.setTag((CompoundTag)item.getOrCreateTag()));
            }
            return ret;
        }
    }

    public static class MechanicVillagerChestLootProvider
    implements LootTableSubProvider {
        public void generate(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            LootPool.Builder lootPool = LootPool.lootPool();
            lootPool.setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).add(this.createEntry((ItemLike)ModItems.COMPRESSED_IRON_INGOT.get(), 10, 4, 12)).add(this.createEntry((ItemLike)ModItems.AMADRON_TABLET.get(), 2, 1, 1)).add(this.createEntry((ItemLike)ModItems.AIR_CANISTER.get(), 10, 1, 5)).add(this.createEntry((ItemLike)ModItems.PNEUMATIC_CYLINDER.get(), 5, 2, 4)).add(this.createEntry((ItemLike)ModItems.LOGISTICS_CORE.get(), 8, 4, 8)).add(this.createEntry((ItemLike)ModItems.CAPACITOR.get(), 4, 4, 8)).add(this.createEntry((ItemLike)ModItems.TRANSISTOR.get(), 4, 4, 8)).add(this.createEntry((ItemLike)ModItems.TURBINE_ROTOR.get(), 5, 2, 4)).add(this.createEntry((ItemLike)ModBlocks.COMPRESSED_IRON_BLOCK.get(), 2, 1, 2)).add(this.createEntry((ItemLike)ModBlocks.VORTEX_TUBE.get(), 5, 1, 1)).add(this.createEntry((ItemLike)ModBlocks.PRESSURE_TUBE.get(), 10, 3, 8)).add(this.createEntry((ItemLike)ModBlocks.ADVANCED_PRESSURE_TUBE.get(), 4, 3, 8)).add(this.createEntry((ItemLike)ModBlocks.HEAT_PIPE.get(), 8, 3, 8)).add(this.createEntry((ItemLike)ModBlocks.APHORISM_TILE.get(), 5, 2, 3));
            LootTable.Builder lootTable = LootTable.lootTable();
            lootTable.withPool(lootPool);
            consumer.accept(PneumaticRegistry.RL("chests/mechanic_house"), lootTable);
        }

        private LootPoolEntryContainer.Builder<?> createEntry(ItemLike item, int weight, int min, int max) {
            return this.createEntry(new ItemStack(item), weight).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max)));
        }

        private LootPoolSingletonContainer.Builder<?> createEntry(ItemStack item, int weight) {
            LootPoolSingletonContainer.Builder ret = LootItem.lootTableItem((ItemLike)item.getItem()).setWeight(weight);
            if (item.hasTag()) {
                ret.apply((LootItemFunction.Builder)SetNbtFunction.setTag((CompoundTag)item.getOrCreateTag()));
            }
            return ret;
        }
    }

    private static class BlockLootTablePNC
    extends BlockLootSubProvider {
        public BlockLootTablePNC() {
            super(Set.of(), FeatureFlags.DEFAULT_FLAGS);
        }

        protected void generate() {
            for (DeferredHolder holder : ModBlocks.BLOCKS.getEntries()) {
                Block b = (Block)holder.get();
                if (b instanceof PneumaticCraftEntityBlock && BuiltInRegistries.ITEM.containsKey(holder.getId())) {
                    this.addStandardSerializedDrop(b, holder.getId());
                    continue;
                }
                if (b instanceof SlabBlock) {
                    this.add(b, x$0 -> this.createSlabItemTable((Block)x$0));
                    continue;
                }
                if (b.asItem() == Items.AIR) continue;
                this.dropSelf(b);
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            ArrayList<Block> l = new ArrayList<Block>();
            for (DeferredHolder holder : ModBlocks.BLOCKS.getEntries()) {
                if (!BuiltInRegistries.ITEM.containsKey(holder.getId())) continue;
                l.add((Block)holder.get());
            }
            return l;
        }

        private void addStandardSerializedDrop(Block block, ResourceLocation blockId) {
            LootPool.Builder builder = LootPool.lootPool().name(blockId.getPath()).when(ExplosionCondition.survivesExplosion()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply(LootFunc.BlockEntitySerializerFunction.builder()));
            this.add(block, LootTable.lootTable().withPool(builder));
        }
    }
}

