/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.world.item.ItemStack;

class SerializerHelper {
    SerializerHelper() {
    }

    static JsonElement serializeOneItemStack(@Nonnull ItemStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("item", PneumaticCraftUtils.getRegistryName(stack.getItem()).orElseThrow().toString());
        if (stack.getCount() > 1) {
            json.addProperty("count", (Number)stack.getCount());
        }
        if (stack.hasTag()) {
            json.addProperty("nbt", Objects.requireNonNull(stack.getTag()).toString());
        }
        return json;
    }

    static JsonElement serializeItemStacks(ItemStack ... stacks) {
        JsonArray res = new JsonArray();
        for (ItemStack stack : stacks) {
            res.add(SerializerHelper.serializeOneItemStack(stack));
        }
        return res;
    }
}

