/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.gui.screen.ExampleEditScreen;
import ca.teamdman.sfm.client.gui.screen.ExamplesScreen;
import ca.teamdman.sfm.client.gui.screen.LabelGunScreen;
import ca.teamdman.sfm.client.gui.screen.LogsScreen;
import ca.teamdman.sfm.client.gui.screen.ProgramEditScreen;
import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.client.render.PrintingPressBlockEntityRenderer;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.net.ServerboundManagerLogDesireUpdatePacket;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="sfm", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientStuff {
    public static void setOrPushScreen(Screen screen) {
        if (Minecraft.getInstance().screen == null) {
            Minecraft.getInstance().setScreen(screen);
        } else {
            Minecraft.getInstance().pushGuiLayer(screen);
        }
    }

    public static void showLabelGunScreen(ItemStack stack, InteractionHand hand) {
        ClientStuff.setOrPushScreen(new LabelGunScreen(stack, hand));
    }

    public static void showProgramEditScreen(String initialContent, Consumer<String> saveCallback) {
        ProgramEditScreen screen = new ProgramEditScreen(initialContent, saveCallback);
        ClientStuff.setOrPushScreen(screen);
        screen.scrollToTop();
    }

    public static void showProgramEditScreen(String initialContent) {
        ClientStuff.showProgramEditScreen(initialContent, x -> {});
    }

    public static void showExampleListScreen(String program, Consumer<String> saveCallback) {
        ClientStuff.setOrPushScreen(new ExamplesScreen((chosenTemplate, templates) -> ClientStuff.showExampleEditScreen(program, chosenTemplate, templates, saveCallback)));
    }

    public static void showExampleEditScreen(String program, String chosenTemplate, Map<String, String> templates, Consumer<String> saveCallback) {
        ExampleEditScreen screen = new ExampleEditScreen(program, chosenTemplate, templates, saveCallback);
        ClientStuff.setOrPushScreen(screen);
        screen.scrollToTop();
    }

    public static void showLogsScreen(ManagerContainerMenu menu) {
        LogsScreen screen = new LogsScreen(menu);
        ClientStuff.setOrPushScreen(screen);
        screen.scrollToBottom();
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ServerboundManagerLogDesireUpdatePacket(menu.containerId, menu.MANAGER_POSITION, true)});
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(SFMBlockEntities.PRINTING_PRESS_BLOCK_ENTITY.get(), PrintingPressBlockEntityRenderer::new);
    }

    public static boolean isMoreInfoKeyDown() {
        long handle = Minecraft.getInstance().getWindow().getWindow();
        return InputConstants.isKeyDown((long)handle, (int)((KeyMapping)SFMKeyMappings.MORE_INFO_TOOLTIP_KEY.get()).getKey().getValue());
    }

    @Nullable
    public static BlockEntity getLookBlockEntity() {
        if (!FMLEnvironment.dist.isClient()) {
            throw new IllegalCallerException("getLookBlockEntity must be called on client");
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        HitResult hr = Minecraft.getInstance().hitResult;
        if (hr == null) {
            return null;
        }
        if (hr.getType() != HitResult.Type.BLOCK) {
            return null;
        }
        BlockPos pos = ((BlockHitResult)hr).getBlockPos();
        return level.getBlockEntity(pos);
    }

    public static String resolveTranslation(TranslatableContents contents) {
        return I18n.get((String)contents.getKey(), (Object[])contents.getArgs());
    }

    public static void showItemInspectorScreen(ItemStack stack) {
        CompoundTag tag = stack.getTag();
        if (tag != null) {
            String content = tag.toString();
            Minecraft.getInstance().keyboardHandler.setClipboard(content);
            SFM.LOGGER.info("Copied {} characters to clipboard", (Object)content.length());
        }
    }
}

