/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundLabelGunClearPacket;
import ca.teamdman.sfm.common.net.ServerboundLabelGunPrunePacket;
import ca.teamdman.sfm.common.net.ServerboundLabelGunUpdatePacket;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class LabelGunScreen
extends Screen {
    private final InteractionHand HAND;
    private final LabelPositionHolder LABEL_HOLDER;
    private EditBox labelField;
    private boolean shouldRebuildWidgets = false;

    public LabelGunScreen(ItemStack labelGunStack, InteractionHand hand) {
        super((Component)LocalizationKeys.LABEL_GUN_GUI_TITLE.getComponent());
        this.LABEL_HOLDER = LabelPositionHolder.from(labelGunStack);
        this.HAND = hand;
    }

    protected void init() {
        super.init();
        assert (this.minecraft != null);
        this.labelField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 150, 50, 300, 20, (Component)LocalizationKeys.LABEL_GUN_GUI_LABEL_PLACEHOLDER.getComponent()));
        this.setInitialFocus((GuiEventListener)this.labelField);
        this.setFocused((GuiEventListener)this.labelField);
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)LocalizationKeys.LABEL_GUN_GUI_CLEAR_BUTTON.getComponent(), __ -> {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ServerboundLabelGunClearPacket(this.HAND)});
            this.LABEL_HOLDER.clear();
            this.shouldRebuildWidgets = true;
        }).pos(this.width / 2 - 210, 50).size(50, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)LocalizationKeys.LABEL_GUN_GUI_PRUNE_BUTTON.getComponent(), btn -> {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ServerboundLabelGunPrunePacket(this.HAND)});
            this.LABEL_HOLDER.prune();
            this.shouldRebuildWidgets = true;
        }).pos(this.width / 2 + 160, 50).size(50, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder(CommonComponents.GUI_DONE, __ -> this.onDone()).pos(this.width / 2 - 2 - 150, this.height - 50).size(300, 20).build());
        List labels = this.LABEL_HOLDER.get().keySet().stream().sorted(Comparator.naturalOrder()).toList();
        int i = 0;
        int buttonWidth = this.LABEL_HOLDER.get().entrySet().stream().map(entry -> LocalizationKeys.LABEL_GUN_GUI_LABEL_BUTTON.getComponent(entry.getKey(), ((Set)entry.getValue()).size()).getString()).mapToInt(arg_0 -> ((Font)this.font).width(arg_0)).max().orElse(50) + 10;
        int buttonHeight = 20;
        int paddingX = 5;
        int paddingY = 5;
        int buttonsPerRow = this.width / (buttonWidth + paddingX);
        for (String label : labels) {
            int x = (this.width - (buttonWidth + paddingX) * Math.min(buttonsPerRow, labels.size())) / 2 + paddingX + i % buttonsPerRow * (buttonWidth + paddingX);
            int y = 80 + i / buttonsPerRow * (buttonHeight + paddingY);
            int count = this.LABEL_HOLDER.getPositions(label).size();
            this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)LocalizationKeys.LABEL_GUN_GUI_LABEL_BUTTON.getComponent(label, count), btn -> {
                this.labelField.setValue(label);
                this.onDone();
            }).pos(x, y).size(buttonWidth, buttonHeight).build());
            ++i;
        }
    }

    public boolean keyPressed(int key, int mod1, int mod2) {
        if (super.keyPressed(key, mod1, mod2)) {
            return true;
        }
        if (key != 257 && key != 335) {
            return false;
        }
        this.onDone();
        return true;
    }

    public void onDone() {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ServerboundLabelGunUpdatePacket(this.labelField.getValue(), this.HAND)});
        this.onClose();
    }

    public void resize(Minecraft mc, int x, int y) {
        String prev = this.labelField.getValue();
        this.init(mc, x, y);
        super.resize(mc, x, y);
        this.labelField.setValue(prev);
    }

    public void render(GuiGraphics graphics, int mx, int my, float partialTicks) {
        if (this.shouldRebuildWidgets) {
            this.shouldRebuildWidgets = false;
            this.rebuildWidgets();
        }
        this.renderTransparentBackground(graphics);
        super.render(graphics, mx, my, partialTicks);
    }
}

