/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.ClientDiagnosticInfo;
import ca.teamdman.sfm.client.ClientStuff;
import ca.teamdman.sfm.client.gui.screen.ExtendedButtonWithTooltip;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.localization.LocalizationEntry;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundManagerFixPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerProgramPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerRebuildPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerResetPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.Level;
import org.joml.Matrix4f;

public class ManagerScreen
extends AbstractContainerScreen<ManagerContainerMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE_LOCATION = new ResourceLocation("sfm", "textures/gui/container/manager.png");
    private final float STATUS_DURATION = 40.0f;
    private Component status = Component.empty();
    private float statusCountdown = 0.0f;
    private ExtendedButton diagButton;
    private ExtendedButton clipboardPasteButton;
    private ExtendedButton clipboardCopyButton;
    private ExtendedButton resetButton;
    private ExtendedButton editButton;
    private ExtendedButton examplesButton;
    private ExtendedButton logsButton;
    private ExtendedButton rebuildButton;

    public ManagerScreen(ManagerContainerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
    }

    public List<ExtendedButton> getButtonsForJEIExclusionZones() {
        return List.of(this.clipboardPasteButton, this.editButton, this.examplesButton, this.clipboardCopyButton, this.logsButton, this.rebuildButton);
    }

    public boolean isReadOnly() {
        LocalPlayer player = Minecraft.getInstance().player;
        return player == null || player.isSpectator();
    }

    public void updateVisibilities() {
        boolean diskPresent = ((ManagerContainerMenu)this.menu).getSlot(0).hasItem();
        this.diagButton.visible = this.shouldShowDiagButton();
        this.clipboardCopyButton.visible = diskPresent;
        this.logsButton.visible = diskPresent;
        this.rebuildButton.visible = diskPresent && !this.isReadOnly();
        this.clipboardPasteButton.visible = diskPresent && !this.isReadOnly();
        this.resetButton.visible = diskPresent && !this.isReadOnly();
        this.editButton.visible = diskPresent && !this.isReadOnly();
    }

    private Tooltip buildTooltip(LocalizationEntry entry) {
        return Tooltip.create((Component)entry.getComponent());
    }

    protected void init() {
        super.init();
        int buttonWidth = 120;
        this.clipboardPasteButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButtonWithTooltip((this.width - this.imageWidth) / 2 - buttonWidth, (this.height - this.imageHeight) / 2 + 16, buttonWidth, 16, (Component)LocalizationKeys.MANAGER_GUI_PASTE_FROM_CLIPBOARD_BUTTON.getComponent(), button -> this.onClipboardPasteButtonClicked(), this.buildTooltip(LocalizationKeys.MANAGER_GUI_PASTE_FROM_CLIPBOARD_BUTTON_TOOLTIP)));
        this.editButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButtonWithTooltip((this.width - this.imageWidth) / 2 - buttonWidth, (this.height - this.imageHeight) / 2 + 16 + 50, buttonWidth, 16, (Component)LocalizationKeys.MANAGER_GUI_EDIT_BUTTON.getComponent(), button -> this.onEditButtonClicked(), this.buildTooltip(LocalizationKeys.MANAGER_GUI_EDIT_BUTTON_TOOLTIP)));
        this.examplesButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButtonWithTooltip((this.width - this.imageWidth) / 2 - buttonWidth, (this.height - this.imageHeight) / 2 + 32 + 50, buttonWidth, 16, (Component)LocalizationKeys.MANAGER_GUI_VIEW_EXAMPLES_BUTTON.getComponent(), button -> this.onExamplesButtonClicked(), this.buildTooltip(LocalizationKeys.MANAGER_GUI_VIEW_EXAMPLES_BUTTON_TOOLTIP)));
        this.clipboardCopyButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton((this.width - this.imageWidth) / 2 - buttonWidth, (this.height - this.imageHeight) / 2 + 128, buttonWidth, 16, (Component)LocalizationKeys.MANAGER_GUI_COPY_TO_CLIPBOARD_BUTTON.getComponent(), button -> this.onClipboardCopyButtonClicked()));
        this.logsButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton((this.width - this.imageWidth) / 2 - buttonWidth, (this.height - this.imageHeight) / 2 + 144, buttonWidth, 16, (Component)LocalizationKeys.MANAGER_GUI_VIEW_LOGS_BUTTON.getComponent(), button -> this.onLogsButtonClicked()));
        this.rebuildButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton((this.width - this.imageWidth) / 2 - buttonWidth, (this.height - this.imageHeight) / 2 + 160, buttonWidth, 16, (Component)LocalizationKeys.MANAGER_GUI_REBUILD_BUTTON.getComponent(), button -> this.onRebuildButtonClicked()));
        this.resetButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButtonWithTooltip((this.width - this.imageWidth) / 2 + 120, (this.height - this.imageHeight) / 2 + 10, 50, 12, (Component)LocalizationKeys.MANAGER_GUI_RESET_BUTTON.getComponent(), button -> this.onResetButtonClicked(), this.buildTooltip(LocalizationKeys.MANAGER_GUI_RESET_BUTTON_TOOLTIP)));
        this.diagButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButtonWithTooltip((this.width - this.imageWidth) / 2 + 35, (this.height - this.imageHeight) / 2 + 48, 12, 14, (Component)Component.literal((String)"!"), button -> this.onDiagButtonClicked(), this.buildTooltip(this.isReadOnly() ? LocalizationKeys.MANAGER_GUI_WARNING_BUTTON_TOOLTIP_READ_ONLY : LocalizationKeys.MANAGER_GUI_WARNING_BUTTON_TOOLTIP)));
        this.updateVisibilities();
    }

    private void onDiagButtonClicked() {
        if (Screen.hasShiftDown() && !this.isReadOnly()) {
            this.sendAttemptFix();
        } else {
            this.onSaveDiagClipboard();
        }
    }

    private void onEditButtonClicked() {
        ClientStuff.showProgramEditScreen(DiskItem.getProgram(((ManagerContainerMenu)this.menu).getDisk()), this::sendProgram);
    }

    private void onExamplesButtonClicked() {
        ClientStuff.showExampleListScreen(DiskItem.getProgram(((ManagerContainerMenu)this.menu).getDisk()), this::sendProgram);
    }

    private void onLogsButtonClicked() {
        ClientStuff.showLogsScreen((ManagerContainerMenu)this.menu);
    }

    private void onResetButtonClicked() {
        ConfirmScreen confirmScreen = new ConfirmScreen(proceed -> {
            assert (this.minecraft != null);
            this.minecraft.popGuiLayer();
            if (proceed) {
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ServerboundManagerResetPacket(((ManagerContainerMenu)this.menu).containerId, ((ManagerContainerMenu)this.menu).MANAGER_POSITION)});
                this.status = LocalizationKeys.MANAGER_GUI_STATUS_RESET.getComponent();
                this.statusCountdown = 40.0f;
            }
        }, (Component)LocalizationKeys.MANAGER_RESET_CONFIRM_SCREEN_TITLE.getComponent(), (Component)LocalizationKeys.MANAGER_RESET_CONFIRM_SCREEN_MESSAGE.getComponent(), (Component)LocalizationKeys.MANAGER_RESET_CONFIRM_SCREEN_YES_BUTTON.getComponent(), (Component)LocalizationKeys.MANAGER_RESET_CONFIRM_SCREEN_NO_BUTTON.getComponent());
        assert (this.minecraft != null);
        this.minecraft.pushGuiLayer((Screen)confirmScreen);
        confirmScreen.setDelay(20);
    }

    private void onRebuildButtonClicked() {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ServerboundManagerRebuildPacket(((ManagerContainerMenu)this.menu).containerId, ((ManagerContainerMenu)this.menu).MANAGER_POSITION)});
        this.status = LocalizationKeys.MANAGER_GUI_STATUS_REBUILD.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void sendAttemptFix() {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ServerboundManagerFixPacket(((ManagerContainerMenu)this.menu).containerId, ((ManagerContainerMenu)this.menu).MANAGER_POSITION)});
        this.status = LocalizationKeys.MANAGER_GUI_STATUS_FIX.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void sendProgram(String program) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ServerboundManagerProgramPacket(((ManagerContainerMenu)this.menu).containerId, ((ManagerContainerMenu)this.menu).MANAGER_POSITION, program)});
        ((ManagerContainerMenu)this.menu).program = program;
        this.status = LocalizationKeys.MANAGER_GUI_STATUS_LOADED_CLIPBOARD.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void onClipboardCopyButtonClicked() {
        try {
            Minecraft.getInstance().keyboardHandler.setClipboard(((ManagerContainerMenu)this.menu).program);
            this.status = LocalizationKeys.MANAGER_GUI_STATUS_SAVED_CLIPBOARD.getComponent();
            this.statusCountdown = 40.0f;
        }
        catch (Throwable t) {
            SFM.LOGGER.error("failed to save clipboard", t);
        }
    }

    private boolean shouldShowDiagButton() {
        ItemStack disk = ((ManagerContainerMenu)this.menu).getDisk();
        if (!(disk.getItem() instanceof DiskItem)) {
            return false;
        }
        List<TranslatableContents> errors = DiskItem.getErrors(disk);
        List<TranslatableContents> warnings = DiskItem.getWarnings(disk);
        return !errors.isEmpty() || !warnings.isEmpty();
    }

    private void onSaveDiagClipboard() {
        try {
            ItemStack disk = ((ManagerContainerMenu)this.menu).CONTAINER.getItem(0);
            if (!(disk.getItem() instanceof DiskItem)) {
                return;
            }
            String diagnosticInfo = ClientDiagnosticInfo.getDiagnosticInfo(((ManagerContainerMenu)this.menu).program, disk);
            Minecraft.getInstance().keyboardHandler.setClipboard(diagnosticInfo);
            this.status = LocalizationKeys.MANAGER_GUI_STATUS_SAVED_CLIPBOARD.getComponent();
            this.statusCountdown = 40.0f;
        }
        catch (Throwable t) {
            SFM.LOGGER.error("failed saving clipboard", t);
        }
    }

    private void onClipboardPasteButtonClicked() {
        try {
            String contents = Minecraft.getInstance().keyboardHandler.getClipboard();
            this.sendProgram(contents);
        }
        catch (Throwable t) {
            SFM.LOGGER.error("failed loading clipboard", t);
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (Screen.isPaste((int)pKeyCode) && this.clipboardPasteButton.visible) {
            this.onClipboardPasteButtonClicked();
            return true;
        }
        if (Screen.isCopy((int)pKeyCode) && this.clipboardCopyButton.visible) {
            this.onClipboardCopyButtonClicked();
            return true;
        }
        if (pKeyCode == 69 && Screen.hasControlDown() && Screen.hasShiftDown() && this.examplesButton.visible) {
            this.onExamplesButtonClicked();
            return true;
        }
        if (pKeyCode == 69 && Screen.hasControlDown() && this.editButton.visible) {
            this.onEditButtonClicked();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    protected void renderLabels(GuiGraphics graphics, int mx, int my) {
        PoseStack poseStack = graphics.pose();
        super.renderLabels(graphics, mx, my);
        ManagerBlockEntity.State state = ((ManagerContainerMenu)this.menu).state;
        graphics.drawString(this.font, (Component)LocalizationKeys.MANAGER_GUI_STATE.getComponent(state.LOC.getComponent().withStyle(state.COLOR)).withStyle(new ChatFormatting[0]), this.titleLabelX, 20, 0, false);
        if (!((ManagerContainerMenu)this.menu).logLevel.equals(Level.OFF.name())) {
            poseStack.pushPose();
            double d = this.titleLabelX;
            Objects.requireNonNull(this.font);
            poseStack.translate(d, 9.0 * 1.5, 0.0);
            poseStack.scale(0.5f, 0.5f, 1.0f);
            graphics.drawString(this.font, (Component)Component.literal((String)((ManagerContainerMenu)this.menu).logLevel), 0, 0, 0, false);
            poseStack.popPose();
        }
        if (this.statusCountdown > 0.0f) {
            graphics.drawString(this.font, this.status, this.inventoryLabelX + this.font.width(this.playerInventoryTitle.getString()) + 5, this.inventoryLabelY, 0, false);
        }
        long peakTickTimeNanoseconds = 0L;
        for (int i = 0; i < ((ManagerContainerMenu)this.menu).tickTimeNanos.length; ++i) {
            peakTickTimeNanoseconds = Long.max(peakTickTimeNanoseconds, ((ManagerContainerMenu)this.menu).tickTimeNanos[i]);
        }
        long yMax = Long.max(peakTickTimeNanoseconds, 50000000L);
        int plotX = this.titleLabelX + 45;
        int plotY = 40;
        int spaceBetweenPoints = 6;
        int plotWidth = 6 * (((ManagerContainerMenu)this.menu).tickTimeNanos.length - 1);
        int plotHeight = 30;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        Matrix4f pose = graphics.pose().last().pose();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        bufferbuilder.vertex(pose, (float)plotX, 40.0f, 0.0f).color(0.0f, 0.0f, 0.0f, 0.5f).endVertex();
        bufferbuilder.vertex(pose, (float)(plotX + plotWidth), 40.0f, 0.0f).color(0.0f, 0.0f, 0.0f, 0.5f).endVertex();
        bufferbuilder.vertex(pose, (float)(plotX + plotWidth), 70.0f, 0.0f).color(0.0f, 0.0f, 0.0f, 0.5f).endVertex();
        bufferbuilder.vertex(pose, (float)plotX, 70.0f, 0.0f).color(0.0f, 0.0f, 0.0f, 0.5f).endVertex();
        bufferbuilder.vertex(pose, (float)plotX, 40.0f, 0.0f).color(0.0f, 0.0f, 0.0f, 0.5f).endVertex();
        tesselator.end();
        bufferbuilder = tesselator.getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        int mouseTickTimeIndex = -1;
        for (int i = 0; i < ((ManagerContainerMenu)this.menu).tickTimeNanos.length; ++i) {
            long y = ((ManagerContainerMenu)this.menu).tickTimeNanos[i];
            float normalizedTickTime = y == 0L ? 0.0f : (float)(Math.log10(y) / Math.log10(yMax));
            int plotPosY = 70 - (int)(normalizedTickTime * 30.0f);
            int plotPosX = plotX + 6 * i;
            ChatFormatting c = this.getMillisecondColour((float)y / 1000000.0f);
            float red = (float)(c.getColor() >> 16 & 0xFF) / 255.0f;
            float green = (float)(c.getColor() >> 8 & 0xFF) / 255.0f;
            float blue = (float)(c.getColor() & 0xFF) / 255.0f;
            bufferbuilder.vertex(pose, (float)plotPosX, (float)plotPosY, 0.0f).color(red, green, blue, 1.0f).endVertex();
            if (mx - this.leftPos < plotPosX - 3 || mx - this.leftPos > plotPosX + 3 || my - this.topPos < 38 || my - this.topPos > 72) continue;
            mouseTickTimeIndex = i;
        }
        tesselator.end();
        DecimalFormat format = new DecimalFormat("0.000");
        if (mouseTickTimeIndex != -1) {
            long hoveredTickTimeNanoseconds = ((ManagerContainerMenu)this.menu).tickTimeNanos[mouseTickTimeIndex];
            float hoveredTickTimeMilliseconds = (float)hoveredTickTimeNanoseconds / 1000000.0f;
            String formattedMillis = format.format(hoveredTickTimeMilliseconds);
            ChatFormatting lagColor = this.getMillisecondColour(hoveredTickTimeMilliseconds);
            MutableComponent milliseconds = Component.literal((String)formattedMillis).withStyle(lagColor);
            MutableComponent mutableComponent = LocalizationKeys.MANAGER_GUI_HOVERED_TICK_TIME_MS.getComponent(milliseconds);
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, (Component)mutableComponent, this.titleLabelX, 20 + 9, 0, false);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            tesselator = Tesselator.getInstance();
            bufferbuilder = tesselator.getBuilder();
            bufferbuilder.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            pose = graphics.pose().last().pose();
            int x = plotX + 6 * mouseTickTimeIndex;
            bufferbuilder.vertex(pose, (float)x, 40.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            bufferbuilder.vertex(pose, (float)x, 70.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            tesselator.end();
        } else {
            float peakTickTimeMilliseconds = (float)peakTickTimeNanoseconds / 1000000.0f;
            String formattedMillis = format.format(peakTickTimeMilliseconds);
            ChatFormatting lagColor = this.getMillisecondColour(peakTickTimeMilliseconds);
            MutableComponent milliseconds = Component.literal((String)formattedMillis).withStyle(lagColor);
            MutableComponent mutableComponent = LocalizationKeys.MANAGER_GUI_PEAK_TICK_TIME_MS.getComponent(milliseconds);
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, (Component)mutableComponent, this.titleLabelX, 20 + 9, 0, false);
        }
        RenderSystem.disableBlend();
    }

    public ChatFormatting getMillisecondColour(float ms) {
        if (ms <= 5.0f) {
            return ChatFormatting.GREEN;
        }
        if (ms <= 15.0f) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.RED;
    }

    public void render(GuiGraphics graphics, int mx, int my, float partialTicks) {
        this.renderTransparentBackground(graphics);
        super.render(graphics, mx, my, partialTicks);
        this.renderTooltip(graphics, mx, my);
        this.updateVisibilities();
        this.statusCountdown -= partialTicks;
    }

    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        if (Minecraft.getInstance().screen != this) {
            this.renderables.stream().filter(AbstractWidget.class::isInstance).map(AbstractWidget.class::cast).forEach(w -> w.setFocused(false));
            return;
        }
        super.renderTooltip(pGuiGraphics, pX, pY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mx, int my) {
        if (!((ManagerContainerMenu)this.menu).logLevel.equals(Level.OFF.name())) {
            RenderSystem.setShaderColor((float)0.2f, (float)0.8f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        graphics.blit(BACKGROUND_TEXTURE_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
    }
}

