/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.block;

import ca.teamdman.sfm.common.blockentity.WaterTankBlockEntity;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.util.SFMUtils;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public class WaterTankBlock
extends BaseEntityBlock
implements EntityBlock,
BucketPickup,
LiquidBlockContainer {
    public static final BooleanProperty IN_WATER = BooleanProperty.create((String)"in_water");

    public WaterTankBlock() {
        super(BlockBehaviour.Properties.of().destroyTime(2.0f).sound(SoundType.WOOD));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)IN_WATER, (Comparable)Boolean.valueOf(false)));
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.onPlace(pState, pLevel, pPos, pOldState, pIsMoving);
        for (Direction direction : Direction.values()) {
            this.recount(pLevel, pPos.offset(direction.getNormal()));
        }
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        for (Direction direction : Direction.values()) {
            this.recount(pLevel, pPos.offset(direction.getNormal()));
        }
    }

    public void appendHoverText(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)LocalizationKeys.WATER_TANK_ITEM_TOOLTIP_1.getComponent().withStyle(ChatFormatting.GRAY));
        pTooltip.add((Component)LocalizationKeys.WATER_TANK_ITEM_TOOLTIP_2.getComponent().withStyle(ChatFormatting.GRAY));
    }

    public void recount(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof WaterTankBlockEntity)) {
            return;
        }
        WaterTankBlockEntity be = (WaterTankBlockEntity)blockEntity;
        List<WaterTankBlockEntity> tanks = SFMUtils.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            for (Direction d : Direction.values()) {
                BlockPos offset = current.getBlockPos().offset(d.getNormal());
                BlockEntity patt3693$temp = level.getBlockEntity(offset);
                if (!(patt3693$temp instanceof WaterTankBlockEntity)) continue;
                WaterTankBlockEntity blockEntity = (WaterTankBlockEntity)patt3693$temp;
                next.accept(blockEntity);
            }
        }, be).toList();
        tanks.forEach(t -> t.setConnectedCount(tanks.size()));
    }

    protected MapCodec<WaterTankBlock> codec() {
        throw new NotImplementedException("This isn't used until 1.20.5 apparently");
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{IN_WATER});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return SFMBlockEntities.WATER_TANK_BLOCK_ENTITY.get().create(pos, state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)IN_WATER, (Comparable)Boolean.valueOf(this.isActive((LevelAccessor)context.getLevel(), context.getClickedPos())));
    }

    public boolean isActive(LevelAccessor level, BlockPos pos) {
        int neighbourWaterCount = 0;
        for (Direction direction : Direction.values()) {
            FluidState state = level.getFluidState(pos.relative(direction));
            if (!state.isSource() || !state.is(FluidTags.WATER) || ++neighbourWaterCount != 2) continue;
            return true;
        }
        return false;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (level.isClientSide) {
            return;
        }
        boolean isActive = this.isActive((LevelAccessor)level, pos);
        if ((Boolean)state.getValue((Property)IN_WATER) != isActive) {
            BlockState newState = (BlockState)this.defaultBlockState().setValue((Property)IN_WATER, (Comparable)Boolean.valueOf(isActive));
            level.setBlock(pos, newState, 3);
        }
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState) {
        return (Boolean)blockState.getValue((Property)IN_WATER) != false ? new ItemStack((ItemLike)Fluids.WATER.getBucket()) : ItemStack.EMPTY;
    }

    public Optional<SoundEvent> getPickupSound() {
        return Fluids.WATER.getPickupSound();
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return fluid.isSame((Fluid)Fluids.WATER);
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluid) {
        return fluid.getType().isSame((Fluid)Fluids.WATER);
    }
}

