/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.blockentity;

import ca.teamdman.sfm.common.block.WaterTankBlock;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class WaterTankBlockEntity
extends BlockEntity {
    public final FluidTank TANK = new FluidTank(1000, fluidStack -> false){
        {
            this.setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (!((Boolean)WaterTankBlockEntity.this.getLevel().getBlockState(WaterTankBlockEntity.this.getBlockPos()).getValue((Property)WaterTankBlock.IN_WATER)).booleanValue()) {
                return FluidStack.EMPTY;
            }
            int drained = Math.min(maxDrain, WaterTankBlockEntity.this.TANK.getCapacity());
            FluidStack copy = this.fluid.copy();
            copy.setAmount(drained);
            return copy;
        }
    };

    public void setConnectedCount(int connectedCount) {
        this.TANK.setCapacity(connectedCount * 1000);
        this.TANK.getFluid().setAmount(this.TANK.getCapacity());
    }

    public void onLoad() {
        super.onLoad();
        ((WaterTankBlock)this.getBlockState().getBlock()).recount(this.getLevel(), this.getBlockPos());
    }

    public WaterTankBlockEntity(BlockPos pos, BlockState state) {
        super(SFMBlockEntities.WATER_TANK_BLOCK_ENTITY.get(), pos, state);
    }
}

