/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.cablenetwork.CapabilityCache;
import ca.teamdman.sfm.common.cablenetwork.ICableBlock;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.logging.TranslatableLogger;
import ca.teamdman.sfm.common.util.SFMUtils;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;

public class CableNetwork {
    protected final Level LEVEL;
    protected final LongSet CABLE_POSITIONS = new LongOpenHashSet();
    protected final CapabilityCache CAPABILITY_CACHE = new CapabilityCache();

    public CableNetwork(Level level) {
        this.LEVEL = level;
    }

    public static boolean isCable(@Nullable Level world, BlockPos cablePos) {
        if (world == null) {
            return false;
        }
        return world.getBlockState(cablePos).getBlock() instanceof ICableBlock;
    }

    public void rebuildNetwork(BlockPos start) {
        this.CABLE_POSITIONS.clear();
        this.CAPABILITY_CACHE.clear();
        this.discoverCables(start).forEach(this::addCable);
    }

    public void rebuildNetworkFromCache(BlockPos start, CableNetwork other) {
        this.CABLE_POSITIONS.clear();
        this.CAPABILITY_CACHE.clear();
        List<BlockPos> cables = SFMUtils.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            for (Direction d : Direction.values()) {
                BlockPos offset = current.offset(d.getNormal());
                if (!other.containsCablePosition(offset)) continue;
                next.accept(offset);
            }
        }, start).toList();
        for (BlockPos cablePos2 : cables) {
            this.CABLE_POSITIONS.add(cablePos2.asLong());
        }
        cables.stream().flatMap(cablePos -> Arrays.stream(Direction.values()).map(Direction::getNormal).map(arg_0 -> ((BlockPos)cablePos).offset(arg_0))).distinct().forEach(pos -> this.CAPABILITY_CACHE.overwriteFromOther((BlockPos)pos, other.CAPABILITY_CACHE));
    }

    public Stream<BlockPos> discoverCables(BlockPos startPos) {
        return SFMUtils.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            for (Direction d : Direction.values()) {
                BlockPos offset = current.offset(d.getNormal());
                if (!CableNetwork.isCable(this.getLevel(), offset)) continue;
                next.accept(offset);
            }
        }, startPos);
    }

    public void addCable(BlockPos pos) {
        this.CABLE_POSITIONS.add(pos.asLong());
    }

    public Level getLevel() {
        return this.LEVEL;
    }

    public String toString() {
        return "CableNetwork{level=" + this.getLevel().dimension().location() + ", #cables=" + this.getCableCount() + ", #cache=" + this.CAPABILITY_CACHE.size() + "}";
    }

    public boolean isAdjacentToCable(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.containsCablePosition(pos.offset(direction.getNormal()))) continue;
            return true;
        }
        return false;
    }

    public boolean containsCablePosition(BlockPos pos) {
        return this.CABLE_POSITIONS.contains(pos.asLong());
    }

    @Nullable
    public <CAP> @Nullable BlockCapabilityCache<CAP, @Nullable Direction> getCapability(BlockCapability<CAP, @Nullable Direction> capKind, BlockPos pos, @Nullable Direction direction, TranslatableLogger logger) {
        if (!this.isAdjacentToCable(pos)) {
            logger.warn(x -> x.accept(LocalizationKeys.LOGS_MISSING_ADJACENT_CABLE.get(pos)));
            return null;
        }
        return this.CAPABILITY_CACHE.getOrDiscoverCapability(this.LEVEL, pos, capKind, direction, logger);
    }

    public int getCableCount() {
        return this.CABLE_POSITIONS.size();
    }

    public void mergeNetwork(CableNetwork other) {
        this.CABLE_POSITIONS.addAll((LongCollection)other.CABLE_POSITIONS);
        this.CAPABILITY_CACHE.putAll(other.CAPABILITY_CACHE);
    }

    public boolean isEmpty() {
        return this.CABLE_POSITIONS.isEmpty();
    }

    public Stream<BlockPos> getCablePositions() {
        return this.CABLE_POSITIONS.longStream().mapToObj(BlockPos::of);
    }

    public LongSet getCablePositionsRaw() {
        return this.CABLE_POSITIONS;
    }

    public Stream<BlockPos> getCapabilityProviderPositions() {
        return this.CAPABILITY_CACHE.getPositions();
    }

    protected List<CableNetwork> withoutCable(BlockPos cablePos) {
        this.CABLE_POSITIONS.remove(cablePos.asLong());
        ArrayList<CableNetwork> branches = new ArrayList<CableNetwork>();
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = cablePos.offset(direction.getNormal());
            if (!this.containsCablePosition(offsetPos) || branches.stream().anyMatch(n -> n.containsCablePosition(offsetPos))) continue;
            CableNetwork branchNetwork = new CableNetwork(this.getLevel());
            branchNetwork.rebuildNetworkFromCache(offsetPos, this);
            branches.add(branchNetwork);
        }
        return branches;
    }

    public void bustCacheForChunk(ChunkAccess chunkAccess) {
        this.CAPABILITY_CACHE.bustCacheForChunk(chunkAccess);
    }
}

