/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.logging.TranslatableLogger;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;

public class CapabilityCache {
    private final Long2ObjectMap<Object2ObjectOpenHashMap<BlockCapability<?, @Nullable Direction>, Object2ObjectOpenHashMap<Direction, BlockCapabilityCache<?, @Nullable Direction>>>> CACHE = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<LongArraySet> CHUNK_TO_BLOCK_POSITIONS = new Long2ObjectOpenHashMap();

    public void clear() {
        this.CACHE.clear();
        this.CHUNK_TO_BLOCK_POSITIONS.clear();
    }

    public int size() {
        return this.CACHE.values().stream().flatMap(x -> x.values().stream()).mapToInt(Object2ObjectOpenHashMap::size).sum();
    }

    public void overwriteFromOther(BlockPos pos, CapabilityCache other) {
        Object2ObjectOpenHashMap found = (Object2ObjectOpenHashMap)other.CACHE.get(pos.asLong());
        if (found != null) {
            this.CACHE.put(pos.asLong(), (Object)new Object2ObjectOpenHashMap((Object2ObjectMap)found));
        }
        this.addToChunkMap(pos);
    }

    @Nullable
    public <CAP> @Nullable BlockCapabilityCache<CAP, @Nullable Direction> getCapability(BlockPos pos, BlockCapability<CAP, Direction> capKind, @Nullable Direction direction) {
        Object2ObjectOpenHashMap dirMap;
        Object2ObjectOpenHashMap capMap;
        if (this.CACHE.containsKey(pos.asLong()) && (capMap = (Object2ObjectOpenHashMap)this.CACHE.get(pos.asLong())).containsKey(capKind) && (dirMap = (Object2ObjectOpenHashMap)capMap.get(capKind)).containsKey((Object)direction)) {
            BlockCapabilityCache found = (BlockCapabilityCache)dirMap.get((Object)direction);
            if (found == null) {
                return null;
            }
            return found;
        }
        return null;
    }

    public void putAll(CapabilityCache other) {
        other.CACHE.forEach((pos, capMap) -> capMap.forEach((capKind, dirMap) -> dirMap.forEach((direction, cap) -> this.putCapability(BlockPos.of((long)pos), (BlockCapability)capKind, (Direction)direction, (BlockCapabilityCache)cap))));
    }

    public Stream<BlockPos> getPositions() {
        return this.CACHE.keySet().longStream().mapToObj(BlockPos::of);
    }

    @Nullable
    public <CAP> @Nullable BlockCapabilityCache<CAP, @Nullable Direction> getOrDiscoverCapability(Level level, BlockPos pos, BlockCapability<CAP, @Nullable Direction> capKind, @Nullable Direction direction, TranslatableLogger logger) {
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockCapabilityCache found = this.getCapability(pos, capKind, direction);
        if (found == null) {
            found = BlockCapabilityCache.create(capKind, (ServerLevel)serverLevel, (BlockPos)pos, (Object)direction, () -> true, () -> this.remove(pos, capKind, direction));
            this.putCapability(pos, capKind, direction, found);
            logger.trace(x -> x.accept(LocalizationKeys.LOG_CAPABILITY_CACHE_MISS.get(pos, capKind.name(), direction)));
        } else {
            logger.trace(x -> x.accept(LocalizationKeys.LOG_CAPABILITY_CACHE_HIT.get(pos, capKind.name(), direction)));
        }
        return found;
    }

    public void remove(BlockPos pos, BlockCapability<?, @Nullable Direction> capKind, @Nullable Direction direction) {
        Object2ObjectOpenHashMap capMap;
        if (this.CACHE.containsKey(pos.asLong()) && (capMap = (Object2ObjectOpenHashMap)this.CACHE.get(pos.asLong())).containsKey(capKind)) {
            Object2ObjectOpenHashMap dirMap = (Object2ObjectOpenHashMap)capMap.get(capKind);
            dirMap.remove((Object)direction);
            if (dirMap.isEmpty()) {
                capMap.remove(capKind);
                if (capMap.isEmpty()) {
                    this.CACHE.remove(pos.asLong());
                }
            }
            this.removeFromChunkMap(pos);
        }
    }

    public <CAP> void putCapability(BlockPos pos, BlockCapability<CAP, @Nullable Direction> capKind, @Nullable Direction direction, BlockCapabilityCache<CAP, @Nullable Direction> entry) {
        Object2ObjectOpenHashMap capMap = (Object2ObjectOpenHashMap)this.CACHE.computeIfAbsent(pos.asLong(), k -> new Object2ObjectOpenHashMap());
        Object2ObjectOpenHashMap dirMap = (Object2ObjectOpenHashMap)capMap.computeIfAbsent(capKind, k -> new Object2ObjectOpenHashMap());
        dirMap.put((Object)direction, entry);
        this.addToChunkMap(pos);
    }

    public void bustCacheForChunk(ChunkAccess chunkAccess) {
        long chunkKey = chunkAccess.getPos().toLong();
        LongArraySet blockPositions = (LongArraySet)this.CHUNK_TO_BLOCK_POSITIONS.get(chunkKey);
        if (blockPositions != null) {
            for (Long blockPos : blockPositions) {
                this.CACHE.remove(blockPos.longValue());
            }
            this.CHUNK_TO_BLOCK_POSITIONS.remove(chunkKey);
        }
    }

    private void addToChunkMap(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        long chunkKey = chunkPos.toLong();
        long blockPos = pos.asLong();
        ((LongArraySet)this.CHUNK_TO_BLOCK_POSITIONS.computeIfAbsent(chunkKey, k -> new LongArraySet())).add(blockPos);
    }

    private void removeFromChunkMap(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        long chunkKey = chunkPos.toLong();
        long blockPos = pos.asLong();
        LongArraySet blockPosSet = (LongArraySet)this.CHUNK_TO_BLOCK_POSITIONS.get(chunkKey);
        if (blockPosSet != null) {
            blockPosSet.remove(blockPos);
            if (blockPosSet.isEmpty()) {
                this.CHUNK_TO_BLOCK_POSITIONS.remove(chunkKey);
            }
        }
    }
}

