/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.handler;

import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.recipe.PrintingPressRecipe;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMRecipeTypes;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FallingAnvilHandler {
    @SubscribeEvent
    public static void onLeave(EntityLeaveLevelEvent event) {
        FallingBlockEntity fbe;
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlockEntity && (fbe = (FallingBlockEntity)entity).getBlockState().getBlock() instanceof AnvilBlock) {
            BlockPos landPosition = fbe.blockPosition();
            Level level = event.getLevel();
            if (!level.isLoaded(landPosition.below())) {
                return;
            }
            Block block = level.getBlockState(landPosition.below()).getBlock();
            if (block == Blocks.IRON_BLOCK) {
                List recipes = level.getRecipeManager().getAllRecipesFor(SFMRecipeTypes.PRINTING_PRESS.get());
                List<ItemEntity> items = level.getEntitiesOfClass(ItemEntity.class, new AABB(landPosition)).stream().filter(Entity::isAlive).filter(e -> !e.getItem().isEmpty()).toList();
                boolean didForm = false;
                block0: for (ItemEntity item : items) {
                    for (RecipeHolder recipe : recipes) {
                        if (!((PrintingPressRecipe)recipe.value()).FORM.test(item.getItem())) continue;
                        didForm = true;
                        item.setItem(FormItem.getForm(item.getItem()));
                        continue block0;
                    }
                }
                if (didForm) {
                    level.setBlockAndUpdate(landPosition.below(), Blocks.AIR.defaultBlockState());
                }
            } else if (block == Blocks.OBSIDIAN) {
                List<ItemEntity> items = level.getEntitiesOfClass(ItemEntity.class, new AABB(landPosition)).stream().filter(Entity::isAlive).filter(e -> !e.getItem().isEmpty()).toList();
                items.stream().filter(e -> e.getItem().is(Items.ENCHANTED_BOOK)).forEach(e -> e.setItem(new ItemStack((ItemLike)SFMItems.EXPERIENCE_SHARD_ITEM.get(), e.getItem().getCount())));
                List<ItemEntity> bookEntities = items.stream().filter(e -> e.getItem().is(Items.BOOK)).toList();
                int booksAvailable = bookEntities.stream().mapToInt(e -> e.getItem().getCount()).sum();
                List<ItemEntity> enchanted = items.stream().filter(e -> !e.getItem().getEnchantmentTags().isEmpty()).toList();
                block2: for (ItemEntity enchItemEntity : enchanted) {
                    ItemStack enchStack = enchItemEntity.getItem();
                    int enchStackSize = enchStack.getCount();
                    Map enchantments = EnchantmentHelper.getEnchantments((ItemStack)enchStack);
                    Iterator enchIter = enchantments.entrySet().iterator();
                    while (enchIter.hasNext()) {
                        Map.Entry entry = enchIter.next();
                        if (booksAvailable < enchStackSize) continue block2;
                        ItemStack toSpawn = new ItemStack((ItemLike)Items.ENCHANTED_BOOK, enchStackSize);
                        EnchantedBookItem.addEnchantment((ItemStack)toSpawn, (EnchantmentInstance)new EnchantmentInstance((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                        level.addFreshEntity((Entity)new ItemEntity(level, (double)landPosition.getX(), (double)landPosition.getY(), (double)landPosition.getZ(), toSpawn));
                        enchIter.remove();
                        EnchantmentHelper.setEnchantments((Map)enchantments, (ItemStack)enchStack);
                        booksAvailable -= enchStackSize;
                        if (!enchantments.isEmpty()) continue;
                        continue block2;
                    }
                }
                for (ItemEntity bookEntity : bookEntities) {
                    bookEntity.kill();
                }
                while (booksAvailable > 0) {
                    int toSpawn = Math.min(booksAvailable, 64);
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)landPosition.getX(), (double)landPosition.getY(), (double)landPosition.getZ(), new ItemStack((ItemLike)Items.BOOK, toSpawn)));
                    booksAvailable -= toSpawn;
                }
            }
        }
    }
}

