/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.item;

import ca.teamdman.sfm.client.ClientStuff;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundLabelGunUsePacket;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class LabelGunItem
extends Item {
    public LabelGunItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public static void setActiveLabel(ItemStack gun, String label) {
        if (label.isEmpty()) {
            return;
        }
        LabelPositionHolder.from(gun).addReferencedLabel(label).save(gun);
        gun.getOrCreateTag().putString("sfm:active_label", label);
    }

    public static String getActiveLabel(ItemStack stack) {
        return !stack.hasTag() ? "" : stack.getTag().getString("sfm:active_label");
    }

    public static String getNextLabel(ItemStack gun, int change) {
        List labels = LabelPositionHolder.from(gun).get().keySet().stream().sorted(Comparator.naturalOrder()).toList();
        if (labels.isEmpty()) {
            return "";
        }
        String currentLabel = LabelGunItem.getActiveLabel(gun);
        int currentLabelIndex = 0;
        for (int i = 0; i < labels.size(); ++i) {
            if (!((String)labels.get(i)).equals(currentLabel)) continue;
            currentLabelIndex = i;
            break;
        }
        int nextLabelIndex = currentLabelIndex + change;
        nextLabelIndex = (nextLabelIndex % labels.size() + labels.size()) % labels.size();
        return (String)labels.get(nextLabelIndex);
    }

    public InteractionResult onItemUseFirst(ItemStack gun, UseOnContext ctx) {
        Level level = ctx.getLevel();
        if (level.isClientSide && ctx.getPlayer() != null) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ServerboundLabelGunUsePacket(ctx.getHand(), ctx.getClickedPos(), Screen.hasControlDown(), ctx.getPlayer().isShiftKeyDown())});
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag detail) {
        lines.add((Component)LocalizationKeys.LABEL_GUN_ITEM_TOOLTIP_1.getComponent().withStyle(ChatFormatting.GRAY));
        lines.add((Component)LocalizationKeys.LABEL_GUN_ITEM_TOOLTIP_2.getComponent().withStyle(ChatFormatting.GRAY));
        lines.add((Component)LocalizationKeys.LABEL_GUN_ITEM_TOOLTIP_3.getComponent().withStyle(ChatFormatting.GRAY));
        lines.addAll(LabelPositionHolder.from(stack).asHoverText());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            ClientStuff.showLabelGunScreen(stack, hand);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public Component getName(ItemStack stack) {
        String name = LabelGunItem.getActiveLabel(stack);
        if (name.isEmpty()) {
            return super.getName(stack);
        }
        return LocalizationKeys.LABEL_GUN_ITEM_NAME_WITH_LABEL.getComponent(name).withStyle(ChatFormatting.AQUA);
    }
}

