/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.item;

import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundNetworkToolUsePacket;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class NetworkToolItem
extends Item {
    public NetworkToolItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext pContext) {
        if (pContext.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ServerboundNetworkToolUsePacket(pContext.getClickedPos(), pContext.getClickedFace())});
        return InteractionResult.CONSUME;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag detail) {
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_1.getComponent().withStyle(ChatFormatting.GRAY));
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_2.getComponent().withStyle(ChatFormatting.GRAY));
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_3.getComponent(((KeyMapping)SFMKeyMappings.CONTAINER_INSPECTOR_KEY.get()).getTranslatedKeyMessage()).withStyle(ChatFormatting.AQUA));
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pIsSelected && !pLevel.isClientSide && pEntity.tickCount % 20 == 0) {
            long maxDistance = 128L;
            CompoundTag tag = new CompoundTag();
            ListTag networks = new ListTag();
            CableNetworkManager.getNetworksInRange(pLevel, pEntity.blockPosition(), 128.0).forEach(net -> {
                CompoundTag networkTag = new CompoundTag();
                networkTag.put("cable_positions", (Tag)net.getCablePositions().map(NbtUtils::writeBlockPos).collect(ListTag::new, AbstractList::add, AbstractCollection::addAll));
                networkTag.put("capability_provider_positions", (Tag)net.getCapabilityProviderPositions().map(NbtUtils::writeBlockPos).collect(ListTag::new, AbstractList::add, AbstractCollection::addAll));
                networks.add((Object)networkTag);
            });
            tag.put("networks", (Tag)networks);
            pStack.setTag(tag);
        }
    }
}

