/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.logging.TranslatableLogEvent;
import ca.teamdman.sfm.common.logging.TranslatableLogger;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayDeque;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record ClientboundManagerLogsPacket(int windowId, FriendlyByteBuf logsBuf) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("sfm", "clientbound_manager_logs_packet");

    public ResourceLocation id() {
        return ID;
    }

    public void write(FriendlyByteBuf friendlyByteBuf) {
        ClientboundManagerLogsPacket.encode(this, friendlyByteBuf);
    }

    public static ClientboundManagerLogsPacket drainToCreate(int windowId, Collection<TranslatableLogEvent> logs) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        TranslatableLogger.encodeAndDrain(logs, buf);
        return new ClientboundManagerLogsPacket(windowId, buf);
    }

    public static void encode(ClientboundManagerLogsPacket msg, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeVarInt(msg.windowId());
        friendlyByteBuf.writeVarInt(msg.logsBuf.readableBytes());
        friendlyByteBuf.writeBytes((ByteBuf)msg.logsBuf, 0, msg.logsBuf.readableBytes());
    }

    public static ClientboundManagerLogsPacket decode(FriendlyByteBuf friendlyByteBuf) {
        int windowId = friendlyByteBuf.readVarInt();
        int size = friendlyByteBuf.readVarInt();
        FriendlyByteBuf logsBuf = new FriendlyByteBuf(Unpooled.buffer((int)size));
        friendlyByteBuf.readBytes((ByteBuf)logsBuf, size);
        return new ClientboundManagerLogsPacket(windowId, logsBuf);
    }

    public static void handle(ClientboundManagerLogsPacket msg, PlayPayloadContext context) {
        context.workHandler().submitAsync(msg::handleInner);
    }

    public void handleInner() {
        ManagerContainerMenu menu;
        block3: {
            block2: {
                AbstractContainerMenu abstractContainerMenu;
                LocalPlayer player = Minecraft.getInstance().player;
                if (player == null || !((abstractContainerMenu = player.containerMenu) instanceof ManagerContainerMenu)) break block2;
                menu = (ManagerContainerMenu)abstractContainerMenu;
                if (menu.containerId == this.windowId()) break block3;
            }
            SFM.LOGGER.error("Invalid logs packet received, ignoring.");
            return;
        }
        ArrayDeque<TranslatableLogEvent> logs = TranslatableLogger.decode(this.logsBuf);
        menu.logs.addAll(logs);
    }
}

