/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.compat.SFMCompat;
import ca.teamdman.sfm.common.compat.SFMMekanismCompat;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ClientboundContainerExportsInspectionResultsPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.SFMUtils;
import ca.teamdman.sfml.ast.DirectionQualifier;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.NumberRangeSet;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceLimit;
import ca.teamdman.sfml.ast.ResourceLimits;
import ca.teamdman.sfml.ast.RoundRobin;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record ServerboundContainerExportsInspectionRequestPacket(int windowId, BlockPos pos) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("sfm", "serverbound_container_exports_inspection_request_packet");

    public void write(FriendlyByteBuf friendlyByteBuf) {
        ServerboundContainerExportsInspectionRequestPacket.encode(this, friendlyByteBuf);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void encode(ServerboundContainerExportsInspectionRequestPacket msg, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeVarInt(msg.windowId());
        friendlyByteBuf.writeBlockPos(msg.pos());
    }

    public static ServerboundContainerExportsInspectionRequestPacket decode(FriendlyByteBuf friendlyByteBuf) {
        return new ServerboundContainerExportsInspectionRequestPacket(friendlyByteBuf.readVarInt(), friendlyByteBuf.readBlockPos());
    }

    public static void handle(ServerboundContainerExportsInspectionRequestPacket msg, PlayPayloadContext context) {
        SFMPackets.handleServerboundContainerPacket(context, AbstractContainerMenu.class, BlockEntity.class, msg.pos, msg.windowId, (menu, blockEntity) -> {
            assert (blockEntity.getLevel() != null);
            Object patt2903$temp = context.player().orElse(null);
            if (!(patt2903$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = patt2903$temp;
            String payload = ServerboundContainerExportsInspectionRequestPacket.buildInspectionResults(blockEntity.getLevel(), blockEntity.getBlockPos());
            PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new ClientboundContainerExportsInspectionResultsPacket(msg.windowId, SFMUtils.truncate(payload, 20480))});
        });
    }

    public static String buildInspectionResults(Level level, BlockPos pos) {
        BlockEntity be;
        StringBuilder sb = new StringBuilder();
        Direction[] dirs = Arrays.copyOf(Direction.values(), Direction.values().length + 1);
        dirs[dirs.length - 1] = null;
        for (Direction direction : dirs) {
            sb.append("-- ").append(direction).append("\n");
            int len = sb.length();
            SFMResourceTypes.DEFERRED_TYPES.entrySet().forEach(entry -> sb.append(ServerboundContainerExportsInspectionRequestPacket.buildInspectionResults((ResourceKey)entry.getKey(), (ResourceType)entry.getValue(), level, pos, direction)));
            if (sb.length() == len) {
                sb.append("No exports found");
            }
            sb.append("\n");
        }
        if (SFMCompat.isMekanismLoaded() && (be = level.getBlockEntity(pos)) != null) {
            sb.append(SFMMekanismCompat.gatherInspectionResults(be)).append("\n");
        }
        return sb.toString();
    }

    public static <STACK, ITEM, CAP> String buildInspectionResults(ResourceKey<ResourceType<STACK, ITEM, CAP>> resourceTypeResourceKey, ResourceType<STACK, ITEM, CAP> resourceType, Level level, BlockPos pos, @Nullable Direction direction) {
        BlockEntity be;
        String result;
        StringBuilder sb = new StringBuilder();
        Object cap = level.getCapability(resourceType.CAPABILITY_KIND, pos, (Object)direction);
        if (cap != null) {
            int slots = resourceType.getSlots(cap);
            Int2ObjectArrayMap slotContents = new Int2ObjectArrayMap(slots);
            for (int slot2 = 0; slot2 < slots; ++slot2) {
                STACK stack2 = resourceType.getStackInSlot(cap, slot2);
                if (resourceType.isEmpty(stack2)) continue;
                slotContents.put(slot2, stack2);
            }
            if (!slotContents.isEmpty()) {
                slotContents.forEach((slot, stack) -> {
                    InputStatement inputStatement = SFMUtils.getInputStatementForStack(resourceTypeResourceKey, resourceType, stack, "target", slot, false, direction);
                    sb.append(inputStatement.toStringPretty()).append("\n");
                });
                ArrayList resourceLimitList = new ArrayList();
                slotContents.forEach((slot, stack) -> {
                    ResourceLocation stackId = resourceType.getRegistryKey(stack);
                    ResourceIdentifier resourceIdentifier = new ResourceIdentifier(resourceTypeResourceKey.location().getNamespace(), resourceTypeResourceKey.location().getPath(), stackId.getNamespace(), stackId.getPath());
                    ResourceLimit resourceLimit = new ResourceLimit(resourceIdentifier, Limit.MAX_QUANTITY_NO_RETENTION, resourceIdentifier.getDefaultWith());
                    resourceLimitList.add(resourceLimit);
                });
                InputStatement inputStatement = new InputStatement(new LabelAccess(List.of(new Label("target")), new DirectionQualifier(direction == null ? EnumSet.noneOf(Direction.class) : EnumSet.of(direction)), NumberRangeSet.MAX_RANGE, RoundRobin.disabled()), new ResourceLimits(resourceLimitList.stream().distinct().toList(), ResourceIdSet.EMPTY), false);
                sb.append(inputStatement.toStringPretty());
            }
        }
        if (!(result = sb.toString()).isBlank() && (be = level.getBlockEntity(pos)) != null && direction == null && BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)be.getType()).getNamespace().equals("mekanism")) {
            return "-- " + LocalizationKeys.CONTAINER_INSPECTOR_MEKANISM_NULL_DIRECTION_WARNING.getString() + "\n" + result;
        }
        return result;
    }
}

