/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.item.DiskItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record ServerboundDiskItemSetProgramPacket(String programString, InteractionHand hand) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("sfm", "serverbound_disk_item_set_program_packet");

    public void write(FriendlyByteBuf friendlyByteBuf) {
        ServerboundDiskItemSetProgramPacket.encode(this, friendlyByteBuf);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void encode(ServerboundDiskItemSetProgramPacket msg, FriendlyByteBuf buf) {
        buf.writeUtf(msg.programString, 80960);
        buf.writeEnum((Enum)msg.hand);
    }

    public static ServerboundDiskItemSetProgramPacket decode(FriendlyByteBuf buf) {
        return new ServerboundDiskItemSetProgramPacket(buf.readUtf(80960), (InteractionHand)buf.readEnum(InteractionHand.class));
    }

    public static void handle(ServerboundDiskItemSetProgramPacket msg, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Object patt1679$temp = context.player().orElse(null);
            if (!(patt1679$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sender = patt1679$temp;
            ItemStack stack = sender.getItemInHand(msg.hand);
            if (stack.getItem() instanceof DiskItem) {
                DiskItem.setProgram(stack, msg.programString);
                DiskItem.compileAndUpdateErrorsAndWarnings(stack, null);
            }
        });
    }
}

