/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.net.ClientboundIfStatementInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ClientboundInputInspectionResultsPacket;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.SimulateExploreAllPathsProgramBehaviour;
import ca.teamdman.sfm.common.util.SFMUtils;
import ca.teamdman.sfml.ast.IfStatement;
import ca.teamdman.sfml.ast.Program;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record ServerboundIfStatementInspectionRequestPacket(String programString, int inputNodeIndex) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("sfm", "serverbound_if_statement_inspection_request_packet");

    public ResourceLocation id() {
        return ID;
    }

    public void write(FriendlyByteBuf friendlyByteBuf) {
        ServerboundIfStatementInspectionRequestPacket.encode(this, friendlyByteBuf);
    }

    public static void encode(ServerboundIfStatementInspectionRequestPacket msg, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeUtf(msg.programString, 80960);
        friendlyByteBuf.writeInt(msg.inputNodeIndex());
    }

    public static ServerboundIfStatementInspectionRequestPacket decode(FriendlyByteBuf friendlyByteBuf) {
        return new ServerboundIfStatementInspectionRequestPacket(friendlyByteBuf.readUtf(80960), friendlyByteBuf.readInt());
    }

    public static void handle(ServerboundIfStatementInspectionRequestPacket msg, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            ManagerBlockEntity mbe;
            BlockEntity patt2582$temp;
            Object patt2321$temp = context.player().orElse(null);
            if (!(patt2321$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = patt2321$temp;
            AbstractContainerMenu patt2471$temp = player.containerMenu;
            if (patt2471$temp instanceof ManagerContainerMenu) {
                ManagerContainerMenu mcm = (ManagerContainerMenu)patt2471$temp;
                patt2582$temp = player.level().getBlockEntity(mcm.MANAGER_POSITION);
                if (!(patt2582$temp instanceof ManagerBlockEntity)) {
                    return;
                }
            } else {
                PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new ClientboundInputInspectionResultsPacket("This inspection is only available when editing inside a manager.")});
                return;
            }
            ManagerBlockEntity manager = mbe = (ManagerBlockEntity)patt2582$temp;
            Program.compile(msg.programString, successProgram -> successProgram.builder().getNodeAtIndex(msg.inputNodeIndex).filter(IfStatement.class::isInstance).map(IfStatement.class::cast).ifPresent(ifStatement -> {
                StringBuilder payload = new StringBuilder();
                payload.append(ifStatement.toStringShort()).append("\n-- peek results --\n");
                ProgramContext programContext = new ProgramContext((Program)successProgram, manager, new SimulateExploreAllPathsProgramBehaviour());
                boolean result = ifStatement.condition().test(programContext);
                payload.append(result ? "TRUE" : "FALSE");
                PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new ClientboundIfStatementInspectionResultsPacket(SFMUtils.truncate(payload.toString(), 2048))});
            }), failure -> {});
        });
    }
}

