/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.net.ClientboundInputInspectionResultsPacket;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.SimulateExploreAllPathsProgramBehaviour;
import ca.teamdman.sfm.common.util.SFMUtils;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Program;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record ServerboundInputInspectionRequestPacket(String programString, int inputNodeIndex) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("sfm", "serverbound_input_inspection_request_packet");

    public void write(FriendlyByteBuf friendlyByteBuf) {
        ServerboundInputInspectionRequestPacket.encode(this, friendlyByteBuf);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void encode(ServerboundInputInspectionRequestPacket msg, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeUtf(msg.programString, 80960);
        friendlyByteBuf.writeInt(msg.inputNodeIndex());
    }

    public static ServerboundInputInspectionRequestPacket decode(FriendlyByteBuf friendlyByteBuf) {
        return new ServerboundInputInspectionRequestPacket(friendlyByteBuf.readUtf(80960), friendlyByteBuf.readInt());
    }

    public static void handle(ServerboundInputInspectionRequestPacket msg, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            ManagerBlockEntity mbe;
            BlockEntity patt2517$temp;
            Object patt2256$temp = context.player().orElse(null);
            if (!(patt2256$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = patt2256$temp;
            AbstractContainerMenu patt2406$temp = player.containerMenu;
            if (patt2406$temp instanceof ManagerContainerMenu) {
                ManagerContainerMenu mcm = (ManagerContainerMenu)patt2406$temp;
                patt2517$temp = player.level().getBlockEntity(mcm.MANAGER_POSITION);
                if (!(patt2517$temp instanceof ManagerBlockEntity)) {
                    return;
                }
            } else {
                PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new ClientboundInputInspectionResultsPacket("This inspection is only available when editing inside a manager.")});
                return;
            }
            ManagerBlockEntity manager = mbe = (ManagerBlockEntity)patt2517$temp;
            Program.compile(msg.programString, successProgram -> successProgram.builder().getNodeAtIndex(msg.inputNodeIndex).filter(InputStatement.class::isInstance).map(InputStatement.class::cast).ifPresent(inputStatement -> {
                StringBuilder payload = new StringBuilder();
                payload.append(inputStatement.toStringPretty()).append("\n-- peek results --\n");
                ProgramContext programContext = new ProgramContext((Program)successProgram, manager, new SimulateExploreAllPathsProgramBehaviour());
                int preLen = payload.length();
                inputStatement.gatherSlots(programContext, slot -> SFMUtils.getInputStatementForSlot(slot, inputStatement.labelAccess()).ifPresent(is -> payload.append(is.toStringPretty()).append("\n")));
                if (payload.length() == preLen) {
                    payload.append("none");
                }
                PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new ClientboundInputInspectionResultsPacket(SFMUtils.truncate(payload.toString(), 20480))});
            }), failure -> {});
        });
    }
}

