/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record ServerboundLabelGunClearPacket(InteractionHand hand) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("sfm", "serverbound_label_gun_clear_packet");

    public void write(FriendlyByteBuf friendlyByteBuf) {
        ServerboundLabelGunClearPacket.encode(this, friendlyByteBuf);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void encode(ServerboundLabelGunClearPacket msg, FriendlyByteBuf buf) {
        buf.writeEnum((Enum)msg.hand);
    }

    public static ServerboundLabelGunClearPacket decode(FriendlyByteBuf buf) {
        return new ServerboundLabelGunClearPacket((InteractionHand)buf.readEnum(InteractionHand.class));
    }

    public static void handle(ServerboundLabelGunClearPacket msg, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Optional sender = context.player();
            if (sender.isEmpty()) {
                return;
            }
            ItemStack stack = ((Player)sender.get()).getItemInHand(msg.hand);
            if (stack.getItem() instanceof LabelGunItem) {
                LabelPositionHolder.empty().save(stack);
            }
        });
    }
}

