/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record ServerboundLabelGunPrunePacket(InteractionHand hand) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("sfm", "serverbound_label_gun_prune_packet");

    public void write(FriendlyByteBuf friendlyByteBuf) {
        ServerboundLabelGunPrunePacket.encode(this, friendlyByteBuf);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void encode(ServerboundLabelGunPrunePacket msg, FriendlyByteBuf buf) {
        buf.writeEnum((Enum)msg.hand);
    }

    public static ServerboundLabelGunPrunePacket decode(FriendlyByteBuf buf) {
        return new ServerboundLabelGunPrunePacket((InteractionHand)buf.readEnum(InteractionHand.class));
    }

    public static void handle(ServerboundLabelGunPrunePacket msg, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Object patt1491$temp = context.player().orElse(null);
            if (!(patt1491$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sender = patt1491$temp;
            ItemStack stack = sender.getItemInHand(msg.hand);
            if (stack.getItem() instanceof LabelGunItem) {
                LabelPositionHolder.from(stack).prune().save(stack);
            }
        });
    }
}

