/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.item.LabelGunItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record ServerboundLabelGunUpdatePacket(String label, InteractionHand hand) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("sfm", "serverbound_label_gun_update_packet");
    public static final int MAX_LABEL_LENGTH = 80;

    public void write(FriendlyByteBuf friendlyByteBuf) {
        ServerboundLabelGunUpdatePacket.encode(this, friendlyByteBuf);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void encode(ServerboundLabelGunUpdatePacket msg, FriendlyByteBuf buf) {
        buf.writeUtf(msg.label, 80);
        buf.writeEnum((Enum)msg.hand);
    }

    public static ServerboundLabelGunUpdatePacket decode(FriendlyByteBuf buf) {
        return new ServerboundLabelGunUpdatePacket(buf.readUtf(80), (InteractionHand)buf.readEnum(InteractionHand.class));
    }

    public static void handle(ServerboundLabelGunUpdatePacket msg, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Object patt1675$temp = context.player().orElse(null);
            if (!(patt1675$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sender = patt1675$temp;
            ItemStack stack = sender.getItemInHand(msg.hand);
            if (stack.getItem() instanceof LabelGunItem) {
                LabelGunItem.setActiveLabel(stack, msg.label);
            }
        });
    }
}

