/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.util.SFMUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record ServerboundLabelGunUsePacket(InteractionHand hand, BlockPos pos, boolean isCtrlKeyDown, boolean isShiftKeyDown) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("sfm", "serverbound_label_gun_use_packet");

    public void write(FriendlyByteBuf friendlyByteBuf) {
        ServerboundLabelGunUsePacket.encode(this, friendlyByteBuf);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void encode(ServerboundLabelGunUsePacket msg, FriendlyByteBuf buf) {
        buf.writeEnum((Enum)msg.hand);
        buf.writeBlockPos(msg.pos);
        buf.writeBoolean(msg.isCtrlKeyDown);
        buf.writeBoolean(msg.isShiftKeyDown);
    }

    public static ServerboundLabelGunUsePacket decode(FriendlyByteBuf buf) {
        return new ServerboundLabelGunUsePacket((InteractionHand)buf.readEnum(InteractionHand.class), buf.readBlockPos(), buf.readBoolean(), buf.readBoolean());
    }

    public static void handle(ServerboundLabelGunUsePacket msg, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Object patt2401$temp = context.player().orElse(null);
            if (!(patt2401$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sender = patt2401$temp;
            ItemStack stack = sender.getItemInHand(msg.hand);
            Level level = sender.level();
            if (!(stack.getItem() instanceof LabelGunItem)) {
                return;
            }
            LabelPositionHolder gunLabels = LabelPositionHolder.from(stack);
            BlockPos pos = msg.pos;
            BlockEntity patt2870$temp = level.getBlockEntity(pos);
            if (patt2870$temp instanceof ManagerBlockEntity) {
                ManagerBlockEntity manager = (ManagerBlockEntity)patt2870$temp;
                manager.getDisk().ifPresent(disk -> {
                    if (msg.isShiftKeyDown) {
                        LabelPositionHolder newLabels = LabelPositionHolder.from(disk);
                        manager.getReferencedLabels().forEach(newLabels::addReferencedLabel);
                        newLabels.save(stack);
                        sender.sendSystemMessage((Component)LocalizationKeys.LABEL_GUN_CHAT_PULLED.getComponent());
                    } else {
                        gunLabels.save((ItemStack)disk);
                        manager.rebuildProgramAndUpdateDisk();
                        manager.setChanged();
                        sender.sendSystemMessage((Component)LocalizationKeys.LABEL_GUN_CHAT_PUSHED.getComponent());
                    }
                });
                return;
            }
            String activeLabel = LabelGunItem.getActiveLabel(stack);
            if (activeLabel.isEmpty()) {
                return;
            }
            if (msg.isCtrlKeyDown) {
                Set cablePositions = CableNetworkManager.getNetworksForLevel(level).flatMap(CableNetwork::getCablePositions).collect(Collectors.toSet());
                Block targetBlock = level.getBlockState(pos).getBlock();
                Predicate<BlockPos> isAdjacentToCable = p -> Arrays.stream(Direction.values()).anyMatch(d -> cablePositions.contains(p.offset(d.getNormal())));
                List<BlockPos> positions = SFMUtils.getRecursiveStream((current, nextQueue, results) -> {
                    results.accept(current);
                    SFMUtils.get3DNeighboursIncludingKittyCorner(current).filter(p -> level.getBlockState(p).getBlock() == targetBlock).filter(isAdjacentToCable).forEach(nextQueue);
                }, pos).toList();
                HashSet<BlockPos> existing = new HashSet<BlockPos>(gunLabels.getPositions(activeLabel));
                boolean anyMissing = positions.stream().anyMatch(p -> !existing.contains(p));
                if (anyMissing) {
                    gunLabels.addAll(activeLabel, positions);
                } else {
                    positions.forEach(p -> gunLabels.remove(activeLabel, (BlockPos)p));
                }
            } else if (msg.isShiftKeyDown) {
                gunLabels.remove(pos);
            } else {
                gunLabels.toggle(activeLabel, pos);
            }
            gunLabels.save(stack);
        });
    }
}

