/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.net.ClientboundLabelInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ServerboundContainerExportsInspectionRequestPacket;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.registry.SFMItems;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record ServerboundLabelInspectionRequestPacket(String label) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("sfm", "serverbound_label_inspection_request_packet");

    public void write(FriendlyByteBuf friendlyByteBuf) {
        ServerboundLabelInspectionRequestPacket.encode(this, friendlyByteBuf);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void encode(ServerboundLabelInspectionRequestPacket msg, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeUtf(msg.label(), 256);
    }

    public static ServerboundLabelInspectionRequestPacket decode(FriendlyByteBuf friendlyByteBuf) {
        return new ServerboundLabelInspectionRequestPacket(friendlyByteBuf.readUtf(256));
    }

    public static void handle(ServerboundLabelInspectionRequestPacket msg, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            LabelPositionHolder labelPositionHolder;
            Object patt1969$temp = context.player().orElse(null);
            if (!(patt1969$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = patt1969$temp;
            SFM.LOGGER.info("Received label inspection request packet from player {}", (Object)player.getStringUUID());
            AbstractContainerMenu patt2244$temp = player.containerMenu;
            if (patt2244$temp instanceof ManagerContainerMenu) {
                ManagerContainerMenu mcm = (ManagerContainerMenu)patt2244$temp;
                SFM.LOGGER.info("Player is using a manager container menu - will append additional info to payload");
                labelPositionHolder = LabelPositionHolder.from(mcm.CONTAINER.getItem(0));
            } else {
                labelPositionHolder = player.getMainHandItem().is(SFMItems.DISK_ITEM.get()) ? LabelPositionHolder.from(player.getMainHandItem()) : (player.getOffhandItem().is(SFMItems.DISK_ITEM.get()) ? LabelPositionHolder.from(player.getOffhandItem()) : null);
            }
            if (labelPositionHolder == null) {
                SFM.LOGGER.info("Label holder wasn't found - aborting");
                return;
            }
            SFM.LOGGER.info("building payload");
            StringBuilder payload = new StringBuilder();
            payload.append("-- Positions for label \"").append(msg.label()).append("\" --\n");
            payload.append(labelPositionHolder.getPositions(msg.label()).size()).append(" assignments\n");
            payload.append("-- Summary --\n");
            labelPositionHolder.get().getOrDefault(msg.label(), Set.of()).forEach(pos -> {
                payload.append(pos.getX()).append(",").append(pos.getY()).append(",").append(pos.getZ());
                if (player.level().isLoaded(pos)) {
                    payload.append(" -- ").append(player.level().getBlockState(pos).getBlock().getName().getString());
                } else {
                    payload.append(" -- chunk not loaded");
                }
                payload.append("\n");
            });
            payload.append("\n\n\n-- Detailed --\n");
            for (BlockPos pos2 : labelPositionHolder.get().getOrDefault(msg.label(), Set.of())) {
                if (payload.length() > 20000) {
                    payload.append("... (truncated)");
                    break;
                }
                payload.append(pos2.getX()).append(",").append(pos2.getY()).append(",").append(pos2.getZ());
                if (player.level().isLoaded(pos2)) {
                    payload.append(" -- ").append(player.level().getBlockState(pos2).getBlock().getName().getString());
                    payload.append("\n").append(ServerboundContainerExportsInspectionRequestPacket.buildInspectionResults(player.level(), pos2).indent(1));
                } else {
                    payload.append(" -- chunk not loaded");
                }
                payload.append("\n");
            }
            SFM.LOGGER.info("Sending payload response length={} to player {}", (Object)payload.length(), (Object)player.getStringUUID());
            PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new ClientboundLabelInspectionResultsPacket(payload.toString())});
        });
    }
}

