/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMPackets;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.apache.logging.log4j.Level;

public record ServerboundManagerSetLogLevelPacket(int windowId, BlockPos pos, String logLevel) implements CustomPacketPayload
{
    public static final int MAX_LOG_LEVEL_NAME_LENGTH = 64;
    public static final ResourceLocation ID = new ResourceLocation("sfm", "serverbound_manager_set_log_level_packet");

    public ResourceLocation id() {
        return ID;
    }

    public void write(FriendlyByteBuf friendlyByteBuf) {
        ServerboundManagerSetLogLevelPacket.encode(this, friendlyByteBuf);
    }

    public static void encode(ServerboundManagerSetLogLevelPacket msg, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeVarInt(msg.windowId());
        friendlyByteBuf.writeBlockPos(msg.pos());
        friendlyByteBuf.writeUtf(msg.logLevel(), 64);
    }

    public static ServerboundManagerSetLogLevelPacket decode(FriendlyByteBuf friendlyByteBuf) {
        return new ServerboundManagerSetLogLevelPacket(friendlyByteBuf.readVarInt(), friendlyByteBuf.readBlockPos(), friendlyByteBuf.readUtf(64));
    }

    public static void handle(ServerboundManagerSetLogLevelPacket msg, PlayPayloadContext context) {
        SFMPackets.handleServerboundContainerPacket(context, ManagerContainerMenu.class, ManagerBlockEntity.class, msg.pos, msg.windowId, (menu, manager) -> {
            Level logLevelObj = Level.getLevel((String)msg.logLevel());
            manager.setLogLevel(logLevelObj);
            manager.logger.info(x -> x.accept(LocalizationKeys.LOG_LEVEL_UPDATED.get(msg.logLevel())));
            String sender = "UNKNOWN SENDER";
            Object patt2711$temp = context.player().orElse(null);
            if (patt2711$temp instanceof ServerPlayer) {
                ServerPlayer player = patt2711$temp;
                sender = player.getName().getString();
            }
            SFM.LOGGER.debug("{} updated manager {} {} log level to {}", (Object)sender, (Object)msg.pos(), (Object)manager.getLevel(), (Object)msg.logLevel());
        });
    }
}

