/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.localization.LocalizationKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class LabelPositionHolder {
    private static final WeakHashMap<ItemStack, LabelPositionHolder> CACHE = new WeakHashMap();
    private final Map<String, Set<BlockPos>> LABELS = new HashMap<String, Set<BlockPos>>();

    private LabelPositionHolder() {
    }

    private LabelPositionHolder(LabelPositionHolder other) {
        other.LABELS.forEach((? super K key, ? super V value) -> this.LABELS.put((String)key, new HashSet(value)));
    }

    public static LabelPositionHolder from(ItemStack stack) {
        return CACHE.computeIfAbsent(stack, s -> {
            CompoundTag tag = stack.getOrCreateTag().getCompound("sfm:labels");
            return LabelPositionHolder.deserialize(tag);
        });
    }

    public static LabelPositionHolder empty() {
        return new LabelPositionHolder();
    }

    public static LabelPositionHolder deserialize(CompoundTag tag) {
        LabelPositionHolder labels = LabelPositionHolder.empty();
        for (String label : tag.getAllKeys()) {
            labels.addAll(label, tag.getList(label, 4).stream().map(LongTag.class::cast).mapToLong(LongTag::getAsLong).mapToObj(BlockPos::of).collect(Collectors.toList()));
            labels.addAll(label, tag.getList(label, 10).stream().map(CompoundTag.class::cast).map(NbtUtils::readBlockPos).collect(Collectors.toList()));
        }
        return labels;
    }

    public LabelPositionHolder save(ItemStack stack) {
        stack.getOrCreateTag().put("sfm:labels", (Tag)this.serialize());
        CACHE.put(stack, new LabelPositionHolder(this));
        return this;
    }

    public static void purge(ItemStack stack) {
        stack.getOrCreateTag().remove("sfm:labels");
        CACHE.remove(stack);
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        for (String label : this.get().keySet()) {
            ListTag list = new ListTag();
            list.addAll(this.LABELS.get(label).stream().map(NbtUtils::writeBlockPos).toList());
            tag.put(label, (Tag)list);
        }
        return tag;
    }

    public boolean contains(String label, BlockPos pos) {
        return this.LABELS.getOrDefault(label, Collections.emptySet()).contains(pos);
    }

    public LabelPositionHolder toggle(String label, BlockPos pos) {
        if (this.contains(label, pos)) {
            this.remove(label, pos);
        } else {
            this.add(label, pos);
        }
        return this;
    }

    public Map<String, Set<BlockPos>> get() {
        return this.LABELS;
    }

    public Set<BlockPos> getPositions(String label) {
        return this.LABELS.computeIfAbsent(label, s -> new HashSet());
    }

    public LabelPositionHolder addAll(String label, Collection<BlockPos> positions) {
        this.getPositions(label).addAll(positions);
        return this;
    }

    public LabelPositionHolder addReferencedLabel(String label) {
        this.getPositions(label);
        return this;
    }

    public List<Component> asHoverText() {
        ArrayList<Component> rtn = new ArrayList<Component>();
        if (this.LABELS.isEmpty()) {
            return rtn;
        }
        rtn.add((Component)LocalizationKeys.DISK_ITEM_TOOLTIP_LABEL_HEADER.getComponent().withStyle(ChatFormatting.UNDERLINE));
        for (Map.Entry<String, Set<BlockPos>> entry : this.LABELS.entrySet()) {
            rtn.add((Component)LocalizationKeys.DISK_ITEM_TOOLTIP_LABEL.getComponent(entry.getKey(), entry.getValue().size()).withStyle(ChatFormatting.GRAY));
        }
        return rtn;
    }

    public LabelPositionHolder remove(BlockPos value) {
        this.LABELS.values().forEach((? super T list) -> list.remove(value));
        return this;
    }

    public LabelPositionHolder prune() {
        this.LABELS.entrySet().removeIf((? super E entry) -> ((Set)entry.getValue()).isEmpty());
        return this;
    }

    public LabelPositionHolder clear() {
        this.LABELS.clear();
        return this;
    }

    public LabelPositionHolder add(String label, BlockPos position) {
        this.getPositions(label).add(position);
        return this;
    }

    public LabelPositionHolder remove(String label, BlockPos pos) {
        this.getPositions(label).remove(pos);
        return this;
    }

    public LabelPositionHolder removeIf(BiPredicate<String, BlockPos> predicate) {
        this.LABELS.forEach((? super K key, ? super V value) -> value.removeIf((? super E pos) -> predicate.test((String)key, (BlockPos)pos)));
        return this;
    }

    public LabelPositionHolder removeIf(Predicate<String> predicate) {
        this.LABELS.keySet().removeIf(predicate);
        return this;
    }

    public LabelPositionHolder forEach(BiConsumer<String, BlockPos> consumer) {
        this.LABELS.forEach((? super K key, ? super V value) -> value.forEach((? super T pos) -> consumer.accept((String)key, (BlockPos)pos)));
        return this;
    }

    public String toString() {
        return "LabelPositionHolder{size=" + this.LABELS.values().stream().mapToInt(Set::size).sum() + "; " + this.LABELS.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + ((Set)entry.getValue()).size()).collect(Collectors.joining(", ")) + "}";
    }
}

