/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceLimit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;

public class OutputResourceTracker<STACK, ITEM, CAP>
implements Predicate<Object> {
    private final ResourceLimit<STACK, ITEM, CAP> LIMIT;
    private final ResourceIdSet EXCLUSIONS;
    private final AtomicLong TRANSFERRED;
    private final AtomicLong RETENTION_OBLIGATION_PROGRESS;

    public OutputResourceTracker(ResourceLimit<STACK, ITEM, CAP> resourceLimit, ResourceIdSet exclusions, AtomicLong transferred, AtomicLong retentionObligationProgress) {
        this.LIMIT = resourceLimit;
        this.EXCLUSIONS = exclusions;
        this.TRANSFERRED = transferred;
        this.RETENTION_OBLIGATION_PROGRESS = retentionObligationProgress;
    }

    public boolean isDone() {
        return this.TRANSFERRED.get() >= this.LIMIT.limit().quantity().number().value() || this.RETENTION_OBLIGATION_PROGRESS.get() >= this.LIMIT.limit().retention().number().value();
    }

    public void updateRetentionObservation(ResourceType<STACK, ITEM, CAP> type, STACK stack) {
        if (this.test(stack)) {
            this.RETENTION_OBLIGATION_PROGRESS.accumulateAndGet(type.getAmount(stack), Long::sum);
        }
    }

    public void trackTransfer(long amount) {
        this.TRANSFERRED.accumulateAndGet(amount, Long::sum);
        this.RETENTION_OBLIGATION_PROGRESS.accumulateAndGet(amount, Long::sum);
    }

    public long getMaxTransferable() {
        long remainingRetentionRoom = this.LIMIT.limit().retention().number().value() - this.RETENTION_OBLIGATION_PROGRESS.get();
        long unusedQuantity = this.LIMIT.limit().quantity().number().value() - this.TRANSFERRED.get();
        return Math.min(unusedQuantity, remainingRetentionRoom);
    }

    public boolean matchesCapabilityType(Object capability) {
        ResourceType<STACK, ITEM, CAP> resourceType = this.LIMIT.resourceId().getResourceType();
        return resourceType != null && resourceType.matchesCapabilityType(capability);
    }

    @Override
    public boolean test(Object stack) {
        return this.LIMIT.test(stack) && !this.EXCLUSIONS.test(stack);
    }

    public ResourceLimit<STACK, ITEM, CAP> getLimit() {
        return this.LIMIT;
    }

    public String toString() {
        return "OutputResourceTracker@" + Integer.toHexString(System.identityHashCode(this)) + "{TRANSFERRED=" + this.TRANSFERRED + ", RETENTION_OBLIGATION_PROGRESS=" + this.RETENTION_OBLIGATION_PROGRESS + ", RESOURCE_LIMIT=" + this.LIMIT + ", EXCLUSIONS=" + this.EXCLUSIONS + "}";
    }
}

