/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.logging.TranslatableLogger;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.program.ProgramBehaviour;
import ca.teamdman.sfm.common.program.SimulateExploreAllPathsProgramBehaviour;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Program;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.level.Level;

public class ProgramContext {
    private final Program PROGRAM;
    private final ManagerBlockEntity MANAGER;
    private final CableNetwork NETWORK;
    private final List<InputStatement> INPUTS = new ArrayList<InputStatement>();
    private final Level LEVEL;
    private final ProgramBehaviour BEHAVIOUR;
    private final int REDSTONE_PULSES;
    private final LabelPositionHolder LABEL_POSITIONS;
    private final TranslatableLogger LOGGER;
    private boolean did_something = false;

    public boolean didSomething() {
        return this.did_something;
    }

    public void setDidSomething(boolean value) {
        this.did_something = value;
    }

    private ProgramContext(Program program, ManagerBlockEntity manager, CableNetwork network, Level level, int redstonePulses, ProgramBehaviour executionBehaviour, LabelPositionHolder labelPositions, TranslatableLogger logger) {
        this.PROGRAM = program;
        this.MANAGER = manager;
        this.NETWORK = network;
        this.LEVEL = level;
        this.REDSTONE_PULSES = redstonePulses;
        this.BEHAVIOUR = executionBehaviour;
        this.LABEL_POSITIONS = labelPositions;
        this.LOGGER = logger;
    }

    public static ProgramContext createSimulationContext(Program program, LabelPositionHolder labelPositionHolder, int redstonePulses, SimulateExploreAllPathsProgramBehaviour behaviour) {
        return new ProgramContext(program, null, null, null, redstonePulses, behaviour, labelPositionHolder, new TranslatableLogger("simulated" + Objects.hash(program, labelPositionHolder, behaviour)));
    }

    public ProgramContext(Program program, ManagerBlockEntity manager, ProgramBehaviour executionBehaviour) {
        this.PROGRAM = program;
        this.MANAGER = manager;
        this.NETWORK = CableNetworkManager.getOrRegisterNetworkFromManagerPosition(this.MANAGER).get();
        assert (this.MANAGER.getLevel() != null);
        this.LEVEL = this.MANAGER.getLevel();
        this.REDSTONE_PULSES = this.MANAGER.getUnprocessedRedstonePulseCount();
        this.BEHAVIOUR = executionBehaviour;
        this.LABEL_POSITIONS = LabelPositionHolder.from(manager.getDisk().get());
        this.LOGGER = manager.logger;
    }

    public LabelPositionHolder getLabelPositionHolder() {
        return this.LABEL_POSITIONS;
    }

    private ProgramContext(ProgramContext other) {
        this.PROGRAM = other.PROGRAM;
        this.MANAGER = other.MANAGER;
        this.NETWORK = other.NETWORK;
        this.LEVEL = other.LEVEL;
        this.REDSTONE_PULSES = other.REDSTONE_PULSES;
        this.BEHAVIOUR = other.BEHAVIOUR.fork();
        this.INPUTS.addAll(other.INPUTS);
        this.did_something = other.did_something;
        this.LABEL_POSITIONS = other.LABEL_POSITIONS;
        this.LOGGER = other.LOGGER;
    }

    public ProgramBehaviour getBehaviour() {
        return this.BEHAVIOUR;
    }

    public Program getProgram() {
        return this.PROGRAM;
    }

    public ProgramContext fork() {
        return new ProgramContext(this);
    }

    public int getRedstonePulses() {
        return this.REDSTONE_PULSES;
    }

    public void free() {
        for (int i = this.INPUTS.size() - 1; i >= 0; --i) {
            this.INPUTS.get(i).freeSlots();
        }
    }

    public ManagerBlockEntity getManager() {
        return this.MANAGER;
    }

    public TranslatableLogger getLogger() {
        return this.LOGGER;
    }

    public void addInput(InputStatement input) {
        this.INPUTS.add(input);
    }

    public List<InputStatement> getInputs() {
        return this.INPUTS;
    }

    public CableNetwork getNetwork() {
        return this.NETWORK;
    }

    public String toString() {
        return "ProgramContext{PROGRAM=" + this.PROGRAM + ", MANAGER=" + this.MANAGER + ", NETWORK=" + this.NETWORK + ", INPUTS=" + this.INPUTS + ", LEVEL=" + this.LEVEL + ", EXECUTION_POLICY=" + this.BEHAVIOUR + ", REDSTONE_PULSES=" + this.REDSTONE_PULSES + ", LABEL_POSITIONS=" + this.LABEL_POSITIONS + ", did_something=" + this.did_something + "}";
    }
}

