/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.item.ExperienceGoop;
import ca.teamdman.sfm.common.item.ExperienceShard;
import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.item.NetworkToolItem;
import ca.teamdman.sfm.common.item.PrintingPressBlockItem;
import ca.teamdman.sfm.common.registry.SFMBlocks;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class SFMItems {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"sfm");
    public static final Supplier<Item> MANAGER_ITEM = SFMItems.register("manager", SFMBlocks.MANAGER_BLOCK);
    public static final Supplier<Item> CABLE_ITEM = SFMItems.register("cable", SFMBlocks.CABLE_BLOCK);
    public static final Supplier<Item> WATER_TANK_ITEM = SFMItems.register("water_tank", SFMBlocks.WATER_TANK_BLOCK);
    public static final Supplier<Item> DISK_ITEM = ITEMS.register("disk", DiskItem::new);
    public static final Supplier<Item> LABEL_GUN_ITEM = ITEMS.register("labelgun", LabelGunItem::new);
    public static final Supplier<Item> NETWORK_TOOL_ITEM = ITEMS.register("network_tool", NetworkToolItem::new);
    public static final Supplier<Item> PRINTING_PRESS_ITEM = ITEMS.register("printing_press", PrintingPressBlockItem::new);
    public static final Supplier<Item> FORM_ITEM = ITEMS.register("form", FormItem::new);
    public static final Supplier<Item> EXPERIENCE_SHARD_ITEM = ITEMS.register("xp_shard", ExperienceShard::new);
    public static final Supplier<Item> EXPERIENCE_GOOP_ITEM = ITEMS.register("xp_goop", ExperienceGoop::new);

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
    }

    private static Supplier<Item> register(String name, Supplier<Block> block) {
        return ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void populateMainCreativeTab(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output output) {
        output.acceptAll(ITEMS.getEntries().stream().map(Supplier::get).map(ItemStack::new).toList());
    }
}

