/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.SFMConfig;
import ca.teamdman.sfml.SFMLBaseVisitor;
import ca.teamdman.sfml.SFMLParser;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Block;
import ca.teamdman.sfml.ast.BoolExpr;
import ca.teamdman.sfml.ast.ComparisonOperator;
import ca.teamdman.sfml.ast.DirectionQualifier;
import ca.teamdman.sfml.ast.ForgetStatement;
import ca.teamdman.sfml.ast.IfStatement;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Interval;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.Number;
import ca.teamdman.sfml.ast.NumberRange;
import ca.teamdman.sfml.ast.NumberRangeSet;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.ast.RedstoneTrigger;
import ca.teamdman.sfml.ast.ResourceComparer;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceLimit;
import ca.teamdman.sfml.ast.ResourceLimits;
import ca.teamdman.sfml.ast.ResourceQuantity;
import ca.teamdman.sfml.ast.RoundRobin;
import ca.teamdman.sfml.ast.SetOperator;
import ca.teamdman.sfml.ast.Side;
import ca.teamdman.sfml.ast.Statement;
import ca.teamdman.sfml.ast.StringHolder;
import ca.teamdman.sfml.ast.TagMatcher;
import ca.teamdman.sfml.ast.TimerTrigger;
import ca.teamdman.sfml.ast.Trigger;
import ca.teamdman.sfml.ast.With;
import ca.teamdman.sfml.ast.WithClause;
import ca.teamdman.sfml.ast.WithTag;
import com.mojang.datafixers.util.Pair;
import cpw.mods.modlauncher.Launcher;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jetbrains.annotations.Nullable;

public class ASTBuilder
extends SFMLBaseVisitor<ASTNode> {
    private final Set<Label> USED_LABELS = new HashSet<Label>();
    private final Set<ResourceIdentifier<?, ?, ?>> USED_RESOURCES = new HashSet();
    private final List<Pair<ASTNode, ParserRuleContext>> AST_NODE_CONTEXTS = new LinkedList<Pair<ASTNode, ParserRuleContext>>();

    public List<Pair<ASTNode, ParserRuleContext>> getNodesUnderCursor(int cursorPos) {
        return this.AST_NODE_CONTEXTS.stream().filter(pair -> pair.getSecond() != null).filter(pair -> ((ParserRuleContext)pair.getSecond()).start.getStartIndex() <= cursorPos && ((ParserRuleContext)pair.getSecond()).stop.getStopIndex() >= cursorPos).collect(Collectors.toList());
    }

    public Optional<ASTNode> getNodeAtIndex(int index) {
        if (index < 0 || index >= this.AST_NODE_CONTEXTS.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ASTNode)this.AST_NODE_CONTEXTS.get(index).getFirst());
    }

    public void setLocationFromOtherNode(ASTNode node, ASTNode otherNode) {
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)node, (Object)((ParserRuleContext)this.AST_NODE_CONTEXTS.get(this.getIndexForNode(otherNode)).getSecond())));
    }

    public int getIndexForNode(ASTNode node) {
        return this.AST_NODE_CONTEXTS.stream().filter(pair -> pair.getFirst() == node).map(this.AST_NODE_CONTEXTS::indexOf).findFirst().orElse(-1);
    }

    public Optional<ParserRuleContext> getContextForNode(ASTNode node) {
        return this.AST_NODE_CONTEXTS.stream().filter(pair -> pair.getFirst() == node).map(Pair::getSecond).findFirst();
    }

    public String getLineColumnForNode(ASTNode node) {
        return this.getContextForNode(node).map(ctx -> "Line " + ctx.start.getLine() + ", Column " + ctx.start.getCharPositionInLine()).orElse("Unknown location");
    }

    @Override
    public StringHolder visitName(@Nullable SFMLParser.NameContext ctx) {
        if (ctx == null) {
            return new StringHolder("");
        }
        StringHolder name = this.visitString(ctx.string());
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)name, (Object)ctx));
        return name;
    }

    @Override
    public ASTNode visitResource(SFMLParser.ResourceContext ctx) {
        String str = ctx.children.stream().map(ParseTree::getText).collect(Collectors.joining()).replaceAll("::", ":*:").replaceAll(":$", ":*").replaceAll("\\*", ".*");
        ResourceIdentifier rtn = ResourceIdentifier.fromString(str);
        this.USED_RESOURCES.add(rtn);
        rtn.assertValid();
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair(rtn, (Object)ctx));
        return rtn;
    }

    @Override
    public ResourceIdentifier<?, ?, ?> visitStringResource(SFMLParser.StringResourceContext ctx) {
        ResourceIdentifier rtn = ResourceIdentifier.fromString(this.visitString(ctx.string()).value());
        this.USED_RESOURCES.add(rtn);
        rtn.assertValid();
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair(rtn, (Object)ctx));
        return rtn;
    }

    @Override
    public StringHolder visitString(SFMLParser.StringContext ctx) {
        String content = ctx.getText();
        StringHolder str = new StringHolder(content.substring(1, content.length() - 1));
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)str, (Object)ctx));
        return str;
    }

    @Override
    public Label visitRawLabel(SFMLParser.RawLabelContext ctx) {
        Label label = new Label(ctx.getText());
        if (label.name().length() > 256) {
            throw new IllegalArgumentException("Label name cannot be longer than 256 characters.");
        }
        this.USED_LABELS.add(label);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)label, (Object)ctx));
        return label;
    }

    @Override
    public Label visitStringLabel(SFMLParser.StringLabelContext ctx) {
        Label label = new Label(this.visitString(ctx.string()).value());
        if (label.name().length() > 256) {
            throw new IllegalArgumentException("Label name cannot be longer than 256 characters.");
        }
        this.USED_LABELS.add(label);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)label, (Object)ctx));
        return label;
    }

    @Override
    public Program visitProgram(SFMLParser.ProgramContext ctx) {
        StringHolder name = this.visitName(ctx.name());
        List<Trigger> triggers = ctx.trigger().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(Trigger.class::cast).collect(Collectors.toList());
        Set<String> labels = this.USED_LABELS.stream().map(Label::name).collect(Collectors.toSet());
        Program program = new Program(this, name.value(), triggers, labels, this.USED_RESOURCES);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)program, (Object)ctx));
        return program;
    }

    @Override
    public ASTNode visitTimerTrigger(SFMLParser.TimerTriggerContext ctx) {
        int minInterval;
        Block block;
        Interval time = (Interval)this.visit((ParseTree)ctx.interval());
        TimerTrigger timerTrigger = new TimerTrigger(time, block = this.visitBlock(ctx.block()));
        int n = minInterval = timerTrigger.usesOnlyForgeEnergyResourceIO() ? ((Integer)SFMConfig.getOrDefault(SFMConfig.COMMON.timerTriggerMinimumIntervalInTicksWhenOnlyForgeEnergyIO)).intValue() : ((Integer)SFMConfig.getOrDefault(SFMConfig.COMMON.timerTriggerMinimumIntervalInTicks)).intValue();
        if (time.getTicks() < minInterval) {
            throw new IllegalArgumentException("Minimum trigger interval is " + minInterval + " ticks.");
        }
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)timerTrigger, (Object)ctx));
        return timerTrigger;
    }

    @Override
    public ASTNode visitBooleanRedstone(SFMLParser.BooleanRedstoneContext ctx) {
        ComparisonOperator comp = ComparisonOperator.GREATER_OR_EQUAL;
        Number num = new Number(0L);
        if (ctx.comparisonOp() != null && ctx.number() != null) {
            comp = this.visitComparisonOp(ctx.comparisonOp());
            num = this.visitNumber(ctx.number());
        }
        ComparisonOperator finalComp = comp;
        if (num.value() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Redstone signal strength cannot be greater than 2147483647");
        }
        int finalNum = (int)num.value();
        BoolExpr boolExpr = new BoolExpr(programContext -> finalComp.test(Long.valueOf(programContext.getManager().getLevel().getBestNeighborSignal(programContext.getManager().getBlockPos())), Long.valueOf(finalNum)), ctx.getText());
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)boolExpr, (Object)ctx));
        return boolExpr;
    }

    @Override
    public ASTNode visitPulseTrigger(SFMLParser.PulseTriggerContext ctx) {
        Block block = this.visitBlock(ctx.block());
        RedstoneTrigger redstoneTrigger = new RedstoneTrigger(block);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)redstoneTrigger, (Object)ctx));
        return redstoneTrigger;
    }

    @Override
    public Number visitNumber(SFMLParser.NumberContext ctx) {
        Number number = new Number(Long.parseLong(ctx.getText()));
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)number, (Object)ctx));
        return number;
    }

    @Override
    public Interval visitTick(SFMLParser.TickContext ctx) {
        Interval interval = Interval.fromTicks(1);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)interval, (Object)ctx));
        return interval;
    }

    @Override
    public Interval visitTicks(SFMLParser.TicksContext ctx) {
        Number num = this.visitNumber(ctx.number());
        if (num.value() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("interval cannot be greater than 2147483647 ticks.");
        }
        Interval interval = Interval.fromTicks((int)num.value());
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)interval, (Object)ctx));
        return interval;
    }

    @Override
    public Interval visitSeconds(SFMLParser.SecondsContext ctx) {
        Number num = this.visitNumber(ctx.number());
        if (num.value() > 0x6666666L) {
            throw new IllegalArgumentException("interval cannot be greater than 2147483647 ticks.");
        }
        Interval interval = Interval.fromSeconds((int)num.value());
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)interval, (Object)ctx));
        return interval;
    }

    @Override
    public InputStatement visitInputStatement(SFMLParser.InputStatementContext ctx) {
        LabelAccess labelAccess = this.visitLabelAccess(ctx.labelAccess());
        ResourceLimits matchers = this.visitInputResourceLimits(ctx.inputResourceLimits());
        ResourceIdSet exclusions = this.visitResourceExclusion(ctx.resourceExclusion());
        boolean each = ctx.EACH() != null;
        InputStatement inputStatement = new InputStatement(labelAccess, matchers.withExclusions(exclusions), each);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)inputStatement, (Object)ctx));
        return inputStatement;
    }

    @Override
    public OutputStatement visitOutputStatement(SFMLParser.OutputStatementContext ctx) {
        LabelAccess labelAccess = this.visitLabelAccess(ctx.labelAccess());
        ResourceLimits matchers = this.visitOutputResourceLimits(ctx.outputResourceLimits());
        ResourceIdSet exclusions = this.visitResourceExclusion(ctx.resourceExclusion());
        boolean each = ctx.EACH() != null;
        OutputStatement outputStatement = new OutputStatement(labelAccess, matchers.withExclusions(exclusions), each);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)outputStatement, (Object)ctx));
        return outputStatement;
    }

    @Override
    public LabelAccess visitLabelAccess(SFMLParser.LabelAccessContext ctx) {
        SFMLParser.SidequalifierContext directionQualifierCtx = ctx.sidequalifier();
        DirectionQualifier directionQualifier = directionQualifierCtx == null ? DirectionQualifier.NULL_DIRECTION : (DirectionQualifier)this.visit((ParseTree)directionQualifierCtx);
        LabelAccess labelAccess = new LabelAccess(ctx.label().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(Label.class::cast).collect(Collectors.toList()), directionQualifier, this.visitSlotqualifier(ctx.slotqualifier()), this.visitRoundrobin(ctx.roundrobin()));
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)labelAccess, (Object)ctx));
        return labelAccess;
    }

    @Override
    public RoundRobin visitRoundrobin(@Nullable SFMLParser.RoundrobinContext ctx) {
        if (ctx == null) {
            return RoundRobin.disabled();
        }
        RoundRobin rtn = ctx.BLOCK() != null ? new RoundRobin(RoundRobin.Behaviour.BY_BLOCK) : new RoundRobin(RoundRobin.Behaviour.BY_LABEL);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)rtn, (Object)ctx));
        return rtn;
    }

    @Override
    public IfStatement visitIfStatement(SFMLParser.IfStatementContext ctx) {
        IfStatement nestedStatement;
        ArrayDeque conditions = ctx.boolexpr().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(BoolExpr.class::cast).collect(Collectors.toCollection(ArrayDeque::new));
        ArrayDeque blocks = ctx.block().stream().map(this::visitBlock).collect(Collectors.toCollection(ArrayDeque::new));
        if (conditions.size() < blocks.size()) {
            Block elseBlock = (Block)blocks.removeLast();
            Block ifBlock = (Block)blocks.removeLast();
            nestedStatement = new IfStatement((BoolExpr)conditions.removeLast(), ifBlock, elseBlock);
        } else {
            nestedStatement = new IfStatement((BoolExpr)conditions.removeLast(), (Block)blocks.removeLast(), new Block(List.of()));
        }
        while (!blocks.isEmpty()) {
            nestedStatement = new IfStatement((BoolExpr)conditions.removeLast(), (Block)blocks.removeLast(), new Block(List.of(nestedStatement)));
        }
        if (!conditions.isEmpty()) {
            throw new IllegalStateException("If statement construction failed to consume all conditions");
        }
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)nestedStatement, (Object)ctx));
        return nestedStatement;
    }

    @Override
    public BoolExpr visitBooleanTrue(SFMLParser.BooleanTrueContext ctx) {
        BoolExpr boolExpr = BoolExpr.TRUE;
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)boolExpr, (Object)ctx));
        return boolExpr;
    }

    @Override
    public BoolExpr visitBooleanHas(SFMLParser.BooleanHasContext ctx) {
        SetOperator setOp = this.visitSetOp(ctx.setOp());
        LabelAccess labelAccess = this.visitLabelAccess(ctx.labelAccess());
        Object comparison = this.visitResourcecomparison(ctx.resourcecomparison());
        BoolExpr booleanExpression = ((ResourceComparer)comparison).toBooleanExpression(setOp, labelAccess, setOp.name().toUpperCase() + " " + labelAccess + " HAS " + (ResourceComparer)comparison);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)booleanExpression, (Object)ctx));
        return booleanExpression;
    }

    @Override
    public SetOperator visitSetOp(@Nullable SFMLParser.SetOpContext ctx) {
        if (ctx == null) {
            return SetOperator.OVERALL;
        }
        SetOperator from = SetOperator.from(ctx.getText());
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)from, (Object)ctx));
        return from;
    }

    @Override
    public ResourceComparer<?, ?, ?> visitResourcecomparison(SFMLParser.ResourcecomparisonContext ctx) {
        ComparisonOperator op = this.visitComparisonOp(ctx.comparisonOp());
        Number num = this.visitNumber(ctx.number());
        ResourceQuantity quantity = new ResourceQuantity(num, ResourceQuantity.IdExpansionBehaviour.NO_EXPAND);
        ResourceIdentifier item = ctx.resourceId() == null ? ResourceIdentifier.MATCH_ALL : (ResourceIdentifier)this.visit((ParseTree)ctx.resourceId());
        ResourceComparer resourceComparer = new ResourceComparer(op, quantity, item);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair(resourceComparer, (Object)ctx));
        return resourceComparer;
    }

    @Override
    public ComparisonOperator visitComparisonOp(SFMLParser.ComparisonOpContext ctx) {
        ComparisonOperator from = ComparisonOperator.from(ctx.getText());
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)from, (Object)ctx));
        return from;
    }

    @Override
    public BoolExpr visitBooleanConjunction(SFMLParser.BooleanConjunctionContext ctx) {
        BoolExpr left = (BoolExpr)this.visit((ParseTree)ctx.boolexpr(0));
        BoolExpr right = (BoolExpr)this.visit((ParseTree)ctx.boolexpr(1));
        BoolExpr boolExpr = new BoolExpr(left.and(right), left.sourceCode() + " AND " + right.sourceCode());
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)boolExpr, (Object)ctx));
        return boolExpr;
    }

    @Override
    public BoolExpr visitBooleanDisjunction(SFMLParser.BooleanDisjunctionContext ctx) {
        BoolExpr left = (BoolExpr)this.visit((ParseTree)ctx.boolexpr(0));
        BoolExpr right = (BoolExpr)this.visit((ParseTree)ctx.boolexpr(1));
        BoolExpr boolExpr = new BoolExpr(left.or(right), left.sourceCode() + " OR " + right.sourceCode());
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)boolExpr, (Object)ctx));
        return boolExpr;
    }

    @Override
    public BoolExpr visitBooleanFalse(SFMLParser.BooleanFalseContext ctx) {
        BoolExpr boolExpr = BoolExpr.FALSE;
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)boolExpr, (Object)ctx));
        return boolExpr;
    }

    @Override
    public BoolExpr visitBooleanParen(SFMLParser.BooleanParenContext ctx) {
        BoolExpr expr = (BoolExpr)this.visit((ParseTree)ctx.boolexpr());
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)expr, (Object)ctx));
        return expr;
    }

    @Override
    public BoolExpr visitBooleanNegation(SFMLParser.BooleanNegationContext ctx) {
        BoolExpr x = (BoolExpr)this.visit((ParseTree)ctx.boolexpr());
        BoolExpr boolExpr = new BoolExpr(x.negate(), "NOT " + x.sourceCode());
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)boolExpr, (Object)ctx));
        return boolExpr;
    }

    @Override
    public Limit visitQuantityRetentionLimit(SFMLParser.QuantityRetentionLimitContext ctx) {
        ResourceQuantity quantity = this.visitQuantity(ctx.quantity());
        ResourceQuantity retain = this.visitRetention(ctx.retention());
        Limit limit = new Limit(quantity, retain);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)limit, (Object)ctx));
        return limit;
    }

    @Override
    public ResourceIdSet visitResourceExclusion(@Nullable SFMLParser.ResourceExclusionContext ctx) {
        if (ctx == null) {
            return ResourceIdSet.EMPTY;
        }
        HashSet ids = ctx.resourceId().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(ResourceIdentifier.class::cast).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        ResourceIdSet resourceIdSet = new ResourceIdSet(ids);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)resourceIdSet, (Object)ctx));
        return resourceIdSet;
    }

    @Override
    public ResourceLimits visitInputResourceLimits(@Nullable SFMLParser.InputResourceLimitsContext ctx) {
        if (ctx == null) {
            return new ResourceLimits(List.of(ResourceLimit.TAKE_ALL_LEAVE_NONE), ResourceIdSet.EMPTY);
        }
        ResourceLimits resourceLimits = ((ResourceLimits)this.visit((ParseTree)ctx.resourceLimits())).withDefaultLimit(Limit.MAX_QUANTITY_NO_RETENTION);
        this.assertResourceLimitDoesntExpandHuge(resourceLimits);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)resourceLimits, (Object)ctx));
        return resourceLimits;
    }

    @Override
    public ResourceLimits visitOutputResourceLimits(@Nullable SFMLParser.OutputResourceLimitsContext ctx) {
        if (ctx == null) {
            return new ResourceLimits(List.of(ResourceLimit.ACCEPT_ALL_WITHOUT_RESTRAINT), ResourceIdSet.EMPTY);
        }
        ResourceLimits resourceLimits = ((ResourceLimits)this.visit((ParseTree)ctx.resourceLimits())).withDefaultLimit(Limit.MAX_QUANTITY_MAX_RETENTION);
        this.assertResourceLimitDoesntExpandHuge(resourceLimits);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)resourceLimits, (Object)ctx));
        return resourceLimits;
    }

    @Override
    public ASTNode visitResourceLimits(SFMLParser.ResourceLimitsContext ctx) {
        ResourceLimits resourceLimits = new ResourceLimits(ctx.resourceLimit().stream().map(resourceLimitContext -> this.visitResourceLimit((SFMLParser.ResourceLimitContext)((Object)resourceLimitContext))).collect(Collectors.toList()), ResourceIdSet.EMPTY);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)resourceLimits, (Object)ctx));
        return resourceLimits;
    }

    @Override
    public ResourceLimit<?, ?, ?> visitResourceLimit(SFMLParser.ResourceLimitContext ctx) {
        ResourceIdentifier resourceIdentifier = ctx.resourceId() == null ? ResourceIdentifier.MATCH_ALL : (ResourceIdentifier)this.visit((ParseTree)ctx.resourceId());
        Limit limit = ctx.limit() == null ? Limit.UNSET : (Limit)this.visit((ParseTree)ctx.limit());
        With with = ctx.with() == null ? With.ALWAYS_TRUE : (With)this.visit((ParseTree)ctx.with());
        ResourceLimit resourceLimit = new ResourceLimit(resourceIdentifier, limit, with);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair(resourceLimit, (Object)ctx));
        return resourceLimit;
    }

    @Override
    public ASTNode visitWith(SFMLParser.WithContext ctx) {
        WithClause clause = (WithClause)this.visit((ParseTree)ctx.withClause());
        With.WithMode mode = ctx.WITHOUT() != null ? With.WithMode.WITHOUT : With.WithMode.WITH;
        With rtn = new With(clause, mode, ctx.getText());
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair(rtn, (Object)ctx));
        return rtn;
    }

    @Override
    public WithTag<?> visitWithTag(SFMLParser.WithTagContext ctx) {
        WithTag rtn = new WithTag((TagMatcher)this.visit((ParseTree)ctx.tagMatcher()));
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair(rtn, (Object)ctx));
        return rtn;
    }

    @Override
    public TagMatcher visitTagMatcher(SFMLParser.TagMatcherContext ctx) {
        ArrayDeque identifiers = ctx.identifier().stream().map(ParseTree::getText).map(s -> s.replaceAll("\\*", ".*")).collect(Collectors.toCollection(ArrayDeque::new));
        TagMatcher rtn = ctx.COLON() == null ? TagMatcher.fromPath(identifiers) : TagMatcher.fromNamespaceAndPath((String)identifiers.pop(), identifiers);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)rtn, (Object)ctx));
        return rtn;
    }

    @Override
    public NumberRangeSet visitSlotqualifier(@Nullable SFMLParser.SlotqualifierContext ctx) {
        NumberRangeSet numberRangeSet = this.visitRangeset(ctx == null ? null : ctx.rangeset());
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)numberRangeSet, (Object)ctx));
        return numberRangeSet;
    }

    @Override
    public ForgetStatement visitForgetStatement(SFMLParser.ForgetStatementContext ctx) {
        Set<Object> labels = ctx.label().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(Label.class::cast).collect(Collectors.toSet());
        if (labels.isEmpty()) {
            labels = this.USED_LABELS;
        }
        ForgetStatement rtn = new ForgetStatement(labels);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)rtn, (Object)ctx));
        return rtn;
    }

    @Override
    public NumberRangeSet visitRangeset(@Nullable SFMLParser.RangesetContext ctx) {
        if (ctx == null) {
            return NumberRangeSet.MAX_RANGE;
        }
        NumberRangeSet numberRangeSet = new NumberRangeSet((NumberRange[])ctx.range().stream().map(this::visitRange).toArray(NumberRange[]::new));
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)numberRangeSet, (Object)ctx));
        return numberRangeSet;
    }

    @Override
    public NumberRange visitRange(SFMLParser.RangeContext ctx) {
        PrimitiveIterator.OfLong iter = ctx.number().stream().map(this::visitNumber).mapToLong(Number::value).iterator();
        Long start = iter.next();
        if (iter.hasNext()) {
            Long end = iter.next();
            NumberRange numberRange = new NumberRange(start, end);
            this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)numberRange, (Object)ctx));
            return numberRange;
        }
        NumberRange numberRange = new NumberRange(start, start);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)numberRange, (Object)ctx));
        return numberRange;
    }

    @Override
    public Limit visitRetentionLimit(SFMLParser.RetentionLimitContext ctx) {
        ResourceQuantity retain = this.visitRetention(ctx.retention());
        Limit limit = new Limit(ResourceQuantity.UNSET, retain);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)limit, (Object)ctx));
        return limit;
    }

    @Override
    public Limit visitQuantityLimit(SFMLParser.QuantityLimitContext ctx) {
        ResourceQuantity quantity = this.visitQuantity(ctx.quantity());
        Limit limit = new Limit(quantity, ResourceQuantity.UNSET);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)limit, (Object)ctx));
        return limit;
    }

    @Override
    public ResourceQuantity visitRetention(@Nullable SFMLParser.RetentionContext ctx) {
        if (ctx == null) {
            return ResourceQuantity.UNSET;
        }
        ResourceQuantity quantity = new ResourceQuantity(this.visitNumber(ctx.number()), ctx.EACH() != null ? ResourceQuantity.IdExpansionBehaviour.EXPAND : ResourceQuantity.IdExpansionBehaviour.NO_EXPAND);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)quantity, (Object)ctx));
        return quantity;
    }

    @Override
    public ResourceQuantity visitQuantity(@Nullable SFMLParser.QuantityContext ctx) {
        if (ctx == null) {
            return ResourceQuantity.MAX_QUANTITY;
        }
        ResourceQuantity quantity = new ResourceQuantity(this.visitNumber(ctx.number()), ctx.EACH() != null ? ResourceQuantity.IdExpansionBehaviour.EXPAND : ResourceQuantity.IdExpansionBehaviour.NO_EXPAND);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)quantity, (Object)ctx));
        return quantity;
    }

    @Override
    public DirectionQualifier visitEachSide(SFMLParser.EachSideContext ctx) {
        DirectionQualifier rtn = DirectionQualifier.EVERY_DIRECTION;
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)rtn, (Object)ctx));
        return rtn;
    }

    @Override
    public DirectionQualifier visitListedSides(SFMLParser.ListedSidesContext ctx) {
        DirectionQualifier directionQualifier = new DirectionQualifier(EnumSet.copyOf(ctx.side().stream().map(this::visitSide).map(DirectionQualifier::lookup).toList()));
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)directionQualifier, (Object)ctx));
        return directionQualifier;
    }

    @Override
    public Side visitSide(SFMLParser.SideContext ctx) {
        Side side = Side.valueOf(ctx.getText().toUpperCase(Locale.ROOT));
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)side, (Object)ctx));
        return side;
    }

    @Override
    public Block visitBlock(@Nullable SFMLParser.BlockContext ctx) {
        if (ctx == null) {
            return new Block(Collections.emptyList());
        }
        List<Statement> statements = ctx.statement().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(Statement.class::cast).collect(Collectors.toList());
        Block block = new Block(statements);
        this.AST_NODE_CONTEXTS.add((Pair<ASTNode, ParserRuleContext>)new Pair((Object)block, (Object)ctx));
        return block;
    }

    private void assertResourceLimitDoesntExpandHuge(ResourceLimits limits) {
        if (Launcher.INSTANCE == null) {
            SFM.LOGGER.warn("The game isn't loaded, Are we in a unit test? Skipping resource limit expansion check.");
            return;
        }
        if (limits.createInputTrackers().size() > 512) {
            throw new IllegalArgumentException("Resource limit expands to more than 512 trackers, this is likely a mistake where the \"EACH\" keyword is being used. The code: " + limits);
        }
    }
}

