/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.LimitedInputSlot;
import ca.teamdman.sfm.common.program.LimitedOutputSlot;
import ca.teamdman.sfm.common.program.LimitedOutputSlotObjectPool;
import ca.teamdman.sfm.common.program.OutputResourceTracker;
import ca.teamdman.sfm.common.program.ProgramBehaviour;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.SimulateExploreAllPathsProgramBehaviour;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.IOStatement;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.ResourceLimits;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class OutputStatement
implements IOStatement {
    private final LabelAccess labelAccess;
    private final ResourceLimits resourceLimits;
    private final boolean each;
    private int lastInputCapacity = 32;
    private int lastOutputCapacity = 32;

    public OutputStatement(LabelAccess labelAccess, ResourceLimits resourceLimits, boolean each) {
        this.labelAccess = labelAccess;
        this.resourceLimits = resourceLimits;
        this.each = each;
    }

    public static <STACK, ITEM, CAP> void moveTo(ProgramContext context, LimitedInputSlot<STACK, ITEM, CAP> source, LimitedOutputSlot<STACK, ITEM, CAP> destination) {
        context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_BEGIN.get(source, destination)));
        if (!source.type.equals(destination.type)) {
            context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_TYPE_MISMATCH.get()));
            return;
        }
        Object potential = source.peekExtractPotential();
        if (!destination.tracker.test(potential)) {
            context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_DESTINATION_TRACKER_REJECT.get()));
            return;
        }
        Object potentialRemainder = destination.insert(potential, true);
        long toMove = source.type.getAmountDifference(potential, potentialRemainder);
        if (toMove <= 0L) {
            context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_ZERO_SIMULATED_MOVEMENT.get(potentialRemainder, potential)));
            return;
        }
        long promised_to_leave_in_this_slot = source.tracker.getExistingRetentionObligation(source.slot);
        long remainingObligation = source.tracker.getRemainingRetentionObligation();
        remainingObligation = Long.min(toMove -= promised_to_leave_in_this_slot, remainingObligation);
        source.tracker.trackRetentionObligation(source.slot, remainingObligation);
        long logRemainingObligation = remainingObligation;
        context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_RETENTION_OBLIGATION.get(promised_to_leave_in_this_slot, logRemainingObligation)));
        if ((toMove -= remainingObligation) <= 0L) {
            context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_RETENTION_OBLIGATION_NO_MOVE.get()));
            source.setDone();
            return;
        }
        long destinationMaxTransferable = destination.tracker.getMaxTransferable();
        toMove = Math.min(toMove, destinationMaxTransferable);
        long sourceMaxTransferable = source.tracker.getMaxTransferable();
        toMove = Math.min(toMove, sourceMaxTransferable);
        long maxStackSize = source.type.getMaxStackSize(potential);
        long logToMove = toMove = Math.min(toMove, maxStackSize);
        context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_STACK_LIMIT_NEW_TO_MOVE.get(destinationMaxTransferable, sourceMaxTransferable, maxStackSize, logToMove)));
        if (toMove <= 0L) {
            context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_ZERO_TO_MOVE.get()));
            return;
        }
        Object extracted = source.extract(toMove);
        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_EXTRACTED.get(extracted, source)));
        Object extractedRemainder = destination.insert(extracted, false);
        long moved = source.type.getAmountDifference(extracted, extractedRemainder);
        source.tracker.trackTransfer(moved);
        destination.tracker.trackTransfer(moved);
        context.getLogger().info(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_END.get(moved, destination.type.getRegistryKey(extracted), source, destination)));
        if (!destination.type.isEmpty(extractedRemainder)) {
            context.getLogger().error(x -> x.accept(LocalizationKeys.LOG_PROGRAM_VOIDED_RESOURCES.get(potential, SFMResourceTypes.DEFERRED_TYPES.getKey(source.type), destination.type.getRegistryKey(potential), extracted, extractedRemainder)));
            SFM.LOGGER.error("!!!RESOURCE LOSS HAS OCCURRED!!! Manager at {} in {} failed to move all promised items, found {} {}:{}, took {} but had {} left over after insertion.", (Object)context.getManager().getBlockPos(), (Object)context.getManager().getLevel(), potential, (Object)SFMResourceTypes.DEFERRED_TYPES.getKey(source.type), (Object)destination.type.getRegistryKey(potential), extracted, extractedRemainder);
        }
    }

    @Override
    public void tick(ProgramContext context) {
        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_OUTPUT_STATEMENT.get(this.toString())));
        ProgramBehaviour programBehaviour = context.getBehaviour();
        if (programBehaviour instanceof SimulateExploreAllPathsProgramBehaviour) {
            SimulateExploreAllPathsProgramBehaviour behaviour = (SimulateExploreAllPathsProgramBehaviour)programBehaviour;
            behaviour.onOutputStatementExecution(context, this);
            return;
        }
        ArrayDeque inputSlots = new ArrayDeque(this.lastInputCapacity + 27);
        for (InputStatement inputStatement : context.getInputs()) {
            inputStatement.gatherSlots(context, inputSlots::add);
        }
        this.lastInputCapacity = inputSlots.size();
        context.getLogger().info(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_OUTPUT_STATEMENT_DISCOVERED_INPUT_SLOT_COUNT.get(inputSlots.size())));
        if (inputSlots.isEmpty()) {
            context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_OUTPUT_STATEMENT_SHORT_CIRCUIT_NO_INPUT_SLOTS.get()));
            return;
        }
        ArrayDeque<LimitedOutputSlot> outputSlots = new ArrayDeque<LimitedOutputSlot>(this.lastOutputCapacity + 27);
        this.gatherSlots(context, outputSlots::add);
        this.lastOutputCapacity = outputSlots.size();
        context.getLogger().info(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_OUTPUT_STATEMENT_DISCOVERED_OUTPUT_SLOT_COUNT.get(outputSlots.size())));
        if (outputSlots.isEmpty()) {
            context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_OUTPUT_STATEMENT_SHORT_CIRCUIT_NO_OUTPUT_SLOTS.get()));
            LimitedOutputSlotObjectPool.release(outputSlots);
            return;
        }
        for (LimitedInputSlot inputSlot : inputSlots) {
            if (inputSlot.isDone()) continue;
            Iterator<LimitedOutputSlot> outputSlotIter = outputSlots.iterator();
            while (outputSlotIter.hasNext()) {
                LimitedOutputSlot outputSlot = outputSlotIter.next();
                if (outputSlot.isDone()) {
                    outputSlotIter.remove();
                    LimitedOutputSlotObjectPool.release(outputSlot);
                    continue;
                }
                OutputStatement.moveTo(context, inputSlot, outputSlot);
                if (!inputSlot.isDone()) continue;
                break;
            }
            if (!outputSlots.isEmpty()) continue;
            break;
        }
        LimitedOutputSlotObjectPool.release(outputSlots);
    }

    public void gatherSlots(ProgramContext context, Consumer<LimitedOutputSlot<?, ?, ?>> slotConsumer) {
        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS.get(this.toStringPretty())));
        Stream<ResourceType> types = this.resourceLimits.getReferencedResourceTypes();
        if (!this.each) {
            context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_NOT_EACH.get()));
            List<OutputResourceTracker<?, ?, ?>> outputTracker = this.resourceLimits.createOutputTrackers();
            for (ResourceType type : types::iterator) {
                context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_FOR_RESOURCE_TYPE.get(type.displayAsCapabilityClass(), type.displayAsCapabilityClass())));
                type.forEachCapability(context, this.labelAccess, (label, pos, direction, cap) -> this.gatherSlotsForCap(context, type, label, pos, direction, cap, outputTracker, slotConsumer));
            }
        } else {
            context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_EACH.get()));
            for (ResourceType type : types::iterator) {
                context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_FOR_RESOURCE_TYPE.get(type.displayAsCapabilityClass(), type.displayAsCapabilityClass())));
                type.forEachCapability(context, this.labelAccess, (label, pos, direction, cap) -> {
                    List<OutputResourceTracker<?, ?, ?>> outputTracker = this.resourceLimits.createOutputTrackers();
                    this.gatherSlotsForCap(context, type, label, pos, direction, cap, outputTracker, slotConsumer);
                });
            }
        }
    }

    @Override
    public LabelAccess labelAccess() {
        return this.labelAccess;
    }

    @Override
    public ResourceLimits resourceLimits() {
        return this.resourceLimits;
    }

    @Override
    public boolean each() {
        return this.each;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        OutputStatement that = (OutputStatement)obj;
        return Objects.equals(this.labelAccess, that.labelAccess) && Objects.equals(this.resourceLimits, that.resourceLimits) && this.each == that.each;
    }

    public int hashCode() {
        return Objects.hash(this.labelAccess, this.resourceLimits, this.each);
    }

    public String toString() {
        return "OUTPUT " + this.resourceLimits.toStringPretty(Limit.MAX_QUANTITY_MAX_RETENTION) + " TO " + (this.each ? "EACH " : "") + this.labelAccess;
    }

    @Override
    public String toStringPretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("OUTPUT");
        String rls = this.resourceLimits.toStringPretty(Limit.MAX_QUANTITY_MAX_RETENTION);
        if (rls.lines().count() > 1L) {
            sb.append("\n");
            sb.append(rls.lines().map(s -> "  " + s).collect(Collectors.joining("\n")));
            sb.append("\n");
        } else {
            sb.append(" ");
            sb.append(rls);
            sb.append(" ");
        }
        sb.append("TO ");
        sb.append(this.each ? "EACH " : "");
        sb.append(this.labelAccess);
        return sb.toString();
    }

    private <STACK, ITEM, CAP> void gatherSlotsForCap(ProgramContext context, ResourceType<STACK, ITEM, CAP> type, Label label, BlockPos pos, Direction direction, CAP capability, List<OutputResourceTracker<?, ?, ?>> trackers, Consumer<LimitedOutputSlot<?, ?, ?>> acceptor) {
        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_RANGE.get(this.labelAccess.slots())));
        for (int slot = 0; slot < type.getSlots(capability); ++slot) {
            int finalSlot = slot;
            if (this.labelAccess.slots().contains(slot)) {
                Object stack = type.getStackInSlot(capability, slot);
                boolean shouldCreateSlot = this.shouldCreateSlot(type, capability, stack, slot);
                for (OutputResourceTracker<?, ?, ?> tracker : trackers) {
                    if (!tracker.matchesCapabilityType(capability)) continue;
                    tracker.updateRetentionObservation(type, stack);
                    if (shouldCreateSlot) {
                        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_SLOT_CREATED.get(finalSlot, stack, tracker.toString())));
                        acceptor.accept(LimitedOutputSlotObjectPool.acquire(label, pos, direction, slot, capability, tracker, stack));
                        continue;
                    }
                    context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_SLOT_SHOULD_NOT_CREATE.get(finalSlot, type.getAmount(stack) + " of " + type.getMaxStackSizeForSlot(capability, finalSlot) + " " + type.getItem(stack))));
                }
                continue;
            }
            context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_SLOT_NOT_IN_RANGE.get(finalSlot)));
        }
    }

    private <STACK, ITEM, CAP> boolean shouldCreateSlot(ResourceType<STACK, ITEM, CAP> type, CAP cap, STACK stack, int slot) {
        return type.getAmount(stack) < type.getMaxStackSizeForSlot(cap, slot);
    }
}

