/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.mixin.rendering.feature;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.WolfCollarLayer;
import net.minecraft.world.entity.animal.Wolf;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.models.IEMFModel;
import traben.entity_model_features.models.parts.EMFModelPartRoot;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.IEMFWolfCollarHolder;

@Mixin(value={WolfCollarLayer.class})
public abstract class MixinWolfCollarFeatureRenderer
extends RenderLayer<Wolf, WolfModel<Wolf>> {
    @Unique
    private static final ModelLayerLocation emf$collar_layer = new ModelLayerLocation(EMFUtils.res("minecraft", "wolf"), "collar");

    public MixinWolfCollarFeatureRenderer(RenderLayerParent<Wolf, WolfModel<Wolf>> context) {
        super(context);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/entity/RenderLayerParent;)V"}, at={@At(value="TAIL")})
    private void setEmf$Model(RenderLayerParent<?, ?> featureRendererContext, CallbackInfo ci) {
        if (EMF.testForForgeLoadingError()) {
            return;
        }
        ModelPart collarModel = EMFManager.getInstance().injectIntoModelRootGetter(emf$collar_layer, WolfModel.createBodyLayer().bakeRoot());
        if (collarModel instanceof EMFModelPartRoot || ((IEMFModel)featureRendererContext.getModel()).emf$isEMFModel()) {
            try {
                EntityModel entityModel = featureRendererContext.getModel();
                if (entityModel instanceof IEMFWolfCollarHolder) {
                    IEMFWolfCollarHolder holder = (IEMFWolfCollarHolder)entityModel;
                    holder.emf$setCollarModel(new WolfModel(collarModel));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @NotNull
    public WolfModel<Wolf> getParentModel() {
        IEMFWolfCollarHolder holder;
        WolfModel base = (WolfModel)super.getParentModel();
        if (base instanceof IEMFWolfCollarHolder && (holder = (IEMFWolfCollarHolder)base).emf$hasCollarModel()) {
            WolfModel model = holder.emf$getCollarModel();
            model.attackTime = base.attackTime;
            model.riding = base.riding;
            model.young = base.young;
            return model;
        }
        return base;
    }
}

