/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client.gui.components;

import com.google.common.collect.Lists;
import fuzs.easyanvils.client.gui.screens.inventory.tooltip.LargeTooltipPositioner;
import fuzs.easyanvils.util.FormattedStringDecomposer;
import fuzs.puzzleslib.api.client.gui.v2.components.ScreenTooltipFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractStringWidget;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class FormattingGuideWidget
extends AbstractStringWidget {
    private static final Component QUESTION_MARK_COMPONENT = Component.literal((String)"?");

    public FormattingGuideWidget(int x, int y, Font font) {
        int n = x - font.width((FormattedText)QUESTION_MARK_COMPONENT) * 2;
        int n2 = font.width((FormattedText)QUESTION_MARK_COMPONENT) * 2;
        Objects.requireNonNull(font);
        super(n, y, n2, 9, QUESTION_MARK_COMPONENT, font);
        this.active = true;
        ArrayList formattingCodes = Lists.newArrayList();
        for (ChatFormatting chatFormatting : ChatFormatting.values()) {
            MutableComponent component = Component.translatable((String)("chat.formatting." + chatFormatting.getName()));
            if (chatFormatting != ChatFormatting.BLACK) {
                component.withStyle(chatFormatting);
            }
            formattingCodes.add(Component.literal((String)("\u00a7" + chatFormatting.getChar())).append(" - ").append((Component)component));
        }
        List<FormattedCharSequence> lines = formattingCodes.stream().map(FormattingGuideWidget::getVisualOrder).toList();
        this.setTooltip(ScreenTooltipFactory.create(lines, (screenRectangle, forKeyboard) -> new LargeTooltipPositioner((ScreenRectangle)(forKeyboard != false ? screenRectangle : null))));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.setColor(this.isHoveredOrFocused() ? ChatFormatting.YELLOW.getColor() : 0x404040);
        int posX = this.getX() + (this.getWidth() - this.getFont().width((FormattedText)this.getMessage())) / 2;
        int posY = this.getY() + (this.getHeight() - 9) / 2;
        guiGraphics.drawString(this.getFont(), this.getMessage(), posX, posY, this.getColor(), false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    private static FormattedCharSequence getVisualOrder(FormattedText text) {
        return formattedCharSink -> text.visit((style, string) -> FormattedStringDecomposer.iterateFormatted(string, style, formattedCharSink) ? Optional.empty() : FormattedText.STOP_ITERATION, Style.EMPTY).isPresent();
    }
}

