/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client.handler;

import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.config.ClientConfig;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.puzzleslib.api.core.v1.Proxy;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class NameTagTooltipHandler {
    public static final String KEY_NAME_TAG_DESCRIPTION = "easyanvils.item.name_tag.description";

    public static void onItemTooltip(ItemStack stack, @Nullable Player player, List<Component> lines, TooltipFlag context) {
        if (!((ClientConfig)EasyAnvils.CONFIG.get(ClientConfig.class)).nameTagTooltip) {
            return;
        }
        if (!EasyAnvils.CONFIG.getHolder(ServerConfig.class).isAvailable() || !((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.editNameTagsNoAnvil) {
            return;
        }
        if (stack.is(Items.NAME_TAG)) {
            MutableComponent sneakComponent = Component.keybind((String)"key.sneak").withStyle(ChatFormatting.LIGHT_PURPLE);
            MutableComponent useComponent = Component.keybind((String)"key.use").withStyle(ChatFormatting.LIGHT_PURPLE);
            MutableComponent component = Component.translatable((String)KEY_NAME_TAG_DESCRIPTION, (Object[])new Object[]{sneakComponent, useComponent}).withStyle(ChatFormatting.GRAY);
            List components = Proxy.INSTANCE.splitTooltipLines((Component)component);
            if (context.isAdvanced()) {
                lines.addAll(lines.size() - (stack.hasTag() ? 2 : 1), components);
            } else {
                lines.addAll(components);
            }
        }
    }
}

