/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.handler;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.init.ModRegistry;
import fuzs.easyanvils.world.level.block.AnvilWithInventoryBlock;
import fuzs.puzzleslib.api.block.v1.BlockConversionHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.init.v3.registry.RegistryHelper;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BlockConversionHandler {
    public static final Component INVALID_BLOCK_COMPONENT = Component.translatable((String)"container.invalidBlock");
    public static final BiMap<Block, Block> BLOCK_CONVERSIONS = HashBiMap.create();

    public static void onRegistryEntryAdded(Registry<Block> registry, ResourceLocation id, Block block, BiConsumer<ResourceLocation, Supplier<Block>> registrar) {
        if (block instanceof AnvilBlock && !(block instanceof AnvilWithInventoryBlock)) {
            ResourceLocation resourceLocation = EasyAnvils.id(id.getNamespace() + "/" + id.getPath());
            registrar.accept(resourceLocation, () -> {
                AnvilWithInventoryBlock newBlock = new AnvilWithInventoryBlock(block);
                BLOCK_CONVERSIONS.put((Object)block, (Object)newBlock);
                return newBlock;
            });
        }
    }

    public static EventResultHolder<InteractionResult> onUseBlock(Player player, Level level, InteractionHand interactionHand, BlockHitResult hitResult) {
        if (!((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.disableVanillaAnvil) {
            return EventResultHolder.pass();
        }
        BlockState blockState = level.getBlockState(hitResult.getBlockPos());
        if (BLOCK_CONVERSIONS.containsKey((Object)blockState.getBlock()) && !blockState.is(ModRegistry.UNALTERED_ANVILS_BLOCK_TAG)) {
            player.displayClientMessage((Component)Component.empty().append(INVALID_BLOCK_COMPONENT).withStyle(ChatFormatting.RED), true);
            return EventResultHolder.interrupt((Object)InteractionResult.sidedSuccess((boolean)level.isClientSide));
        }
        return EventResultHolder.pass();
    }

    public static void onTagsUpdated(RegistryAccess registryAccess, boolean client) {
        for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)v;
            Block block = blockItem.getBlock();
            BlockConversionHandler.setItemForBlock(((ResourceKey)entry.getKey()).location(), blockItem, block);
            BlockConversionHandler.setBlockForItem(blockItem, block);
        }
        BlockConversionHandler.copyBoundTags();
    }

    private static void setItemForBlock(ResourceLocation resourceLocation, BlockItem blockItem, Block block) {
        if (block instanceof AnvilBlock && !(block instanceof AnvilWithInventoryBlock)) {
            BlockConversionHelper.setItemForBlock((Block)((Block)BLOCK_CONVERSIONS.get((Object)block)), (Item)blockItem);
        }
    }

    private static void setBlockForItem(BlockItem blockItem, Block block) {
        Block baseBlock;
        Block diagonalBlock = (Block)BLOCK_CONVERSIONS.get((Object)block);
        if (diagonalBlock != null) {
            baseBlock = block;
        } else {
            baseBlock = (Block)BLOCK_CONVERSIONS.inverse().get((Object)block);
            if (baseBlock != null) {
                diagonalBlock = block;
            } else {
                return;
            }
        }
        if (RegistryHelper.is(ModRegistry.UNALTERED_ANVILS_BLOCK_TAG, (Object)baseBlock)) {
            BlockConversionHelper.setBlockForItem((BlockItem)blockItem, (Block)baseBlock);
        } else {
            BlockConversionHelper.setBlockForItem((BlockItem)blockItem, (Block)diagonalBlock);
        }
    }

    private static void copyBoundTags() {
        BLOCK_CONVERSIONS.forEach(BlockConversionHelper::copyBoundTags);
    }

    public static <T extends Comparable<T>, V extends T> BlockState copyAllProperties(BlockState blockState, Map<Property<?>, Comparable<?>> values) {
        for (Map.Entry<Property<?>, Comparable<?>> entry : values.entrySet()) {
            blockState = (BlockState)blockState.trySetValue(entry.getKey(), entry.getValue());
        }
        return blockState;
    }

    public static BlockState convertReplacementToOriginal(@Nullable BlockState blockState) {
        if (blockState != null && BLOCK_CONVERSIONS.containsValue((Object)blockState.getBlock())) {
            Block block = (Block)BLOCK_CONVERSIONS.inverse().get((Object)blockState.getBlock());
            return BlockConversionHandler.copyAllProperties(block.defaultBlockState(), blockState.getValues());
        }
        return blockState;
    }

    public static BlockState convertOriginalToReplacement(@Nullable BlockState blockState) {
        if (blockState != null && BLOCK_CONVERSIONS.containsKey((Object)blockState.getBlock())) {
            Block block = (Block)BLOCK_CONVERSIONS.get((Object)blockState.getBlock());
            return BlockConversionHandler.copyAllProperties(block.defaultBlockState(), blockState.getValues());
        }
        return blockState;
    }
}

